/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.virtualkeystore.core.DelegatingResolver;
import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreFileResolver;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreSecurityResolver;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import jakarta.persistence.EntityManager;
import java.net.URI;

public class DBKeyStoreResolver
extends DelegatingResolver {
    public static final String SCHEME = "db";
    private final EntityManager entityManager;
    private final IPrivateKeyProtection privateKeyProtection;

    public static boolean supports(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    public DBKeyStoreResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection) {
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    public DBKeyStoreResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection, String path) {
        super(path);
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    protected IResolver createDelegateResolver() {
        if (this.getPath().startsWith("key:") || this.getPath().startsWith("certificate:")) {
            return new DBKeyStoreSecurityResolver(this.getEntityManager(), this.getPrivateKeyProtection(), this.getPath());
        }
        if (this.getPath().startsWith("file:")) {
            return new DBKeyStoreFileResolver(this.getEntityManager(), this.getPath());
        }
        return null;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public IPrivateKeyProtection getPrivateKeyProtection() {
        return this.privateKeyProtection;
    }
}

