/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.jpa.common.BasicPersistentObject;
import de.intarsys.jpa.common.IdObject;
import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.Key;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.virtualkeystore.core.CommonResolver;
import de.intarsys.security.virtualkeystore.core.ICertificateResolver;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class DBKeyStoreSecurityResolver
extends CommonResolver
implements ICertificateResolver,
IPrivateKeyResolver {
    private final EntityManager entityManager;
    private final IPrivateKeyProtection privateKeyProtection;

    protected static Class getModelClass(String path) {
        if (path.startsWith("key:")) {
            return Key.class;
        }
        if (path.startsWith("certificate:")) {
            return Certificate.class;
        }
        return null;
    }

    public static IdObject lookupEntity(EntityManager em, String path) {
        Class meta = DBKeyStoreSecurityResolver.getModelClass(path);
        if (meta == null) {
            return null;
        }
        int id = Integer.parseInt(path.substring(path.indexOf(58) + 1));
        return (IdObject)BasicPersistentObject.lookup((EntityManager)em, (Class)meta, (Object)id);
    }

    public DBKeyStoreSecurityResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection) {
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    public DBKeyStoreSecurityResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection, String path) {
        super(path);
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    public synchronized IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        IdObject entity = DBKeyStoreSecurityResolver.lookupEntity(this.getEntityManager(), this.getPath());
        if (!(entity instanceof Certificate)) {
            return null;
        }
        Certificate dbCertificate = (Certificate)entity;
        try {
            return DBKeyStoreTools.getX509Certificate(dbCertificate);
        }
        catch (ConversionException e) {
            GeneralSecurityException gse = (GeneralSecurityException)ExceptionTools.getFromChain((Throwable)e, GeneralSecurityException.class);
            if (gse != null) {
                throw gse;
            }
            throw new GeneralSecurityException(e);
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        IdObject entity = DBKeyStoreSecurityResolver.lookupEntity(this.getEntityManager(), this.getPath());
        if (!(entity instanceof Key)) {
            return null;
        }
        Key dbKey = (Key)entity;
        return DBKeyStoreTools.getPrivateKey(dbKey, password, this.getPrivateKeyProtection());
    }

    public IPrivateKeyProtection getPrivateKeyProtection() {
        return this.privateKeyProtection;
    }
}

