/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.Key;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.model.common.security.ServiceInformation;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.security.virtualkeystore.db.IWrappedPrivateKey;
import de.intarsys.security.virtualkeystore.db.URIResolver;
import de.intarsys.security.virtualkeystore.db.WrappedPrivateKey;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.hex.HexTools;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.X509Extension;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;

public final class DBKeyStoreTools {
    public static Certificate createDBCertificate(IX509Certificate certificate) throws IOException, GeneralSecurityException {
        Certificate dbCertificate = new Certificate();
        dbCertificate.setCertificate(certificate.getEncoded());
        dbCertificate.setIssuer(certificate.getIssuerX500Principal().toString());
        X500Principal subject = certificate.getSubjectX500Principal();
        if (subject == null) {
            dbCertificate.setSubject("");
        } else {
            dbCertificate.setSubject(subject.toString());
        }
        dbCertificate.setSerial(certificate.getSerialNumber().toString());
        byte[] subjectKeyIdentifier = null;
        subjectKeyIdentifier = CertificateTools.getSubjectKeyIdentifier((X509Extension)certificate);
        if (subjectKeyIdentifier != null) {
            dbCertificate.setSubjectKeyIdentifier(HexTools.bytesToHexString((byte[])subjectKeyIdentifier));
        }
        return dbCertificate;
    }

    public static Key createDBKey(PrivateKey key, Secret password, IPrivateKeyProtection privateKeyProtection) throws GeneralSecurityException, IOException {
        Key dbKey = new Key();
        byte[] keyData = key.getEncoded();
        if (password != null) {
            IWrappedPrivateKey wrappedPrivateKey = privateKeyProtection.encrypt(key, password);
            PrivateKey decryptedPrivateKey = privateKeyProtection.decrypt(wrappedPrivateKey, password);
            if (!Arrays.equals(key.getEncoded(), decryptedPrivateKey.getEncoded())) {
                throw new GeneralSecurityException("Error wrapping key!");
            }
            keyData = wrappedPrivateKey.getData();
            dbKey.setEncryptionAlgorithm(wrappedPrivateKey.getEncryptionAlgorithm());
            dbKey.setEncryptionAlgorithmParameters(wrappedPrivateKey.getEncryptionAlgorithmParameters());
        }
        dbKey.setKey(keyData);
        dbKey.setKeyAlgorithm(key.getAlgorithm());
        return dbKey;
    }

    public static KeyRef createDBKeyRef(String uri, Certificate dbCertificate) {
        KeyRef keyRef = new KeyRef();
        keyRef.setCertificate(dbCertificate);
        keyRef.setKeyUri(uri);
        return keyRef;
    }

    public static String createDBKeyRefUri(Key dbKey) {
        return "db:key:" + dbKey.getId();
    }

    public static ServiceInformation createDBServiceInformation(IServiceType serviceType, String name, Certificate dbCertificate) {
        ServiceInformation result = new ServiceInformation();
        result.setName(name);
        result.setType(serviceType.getUri());
        result.setCertificate(dbCertificate);
        return result;
    }

    public static Certificate getDBCertificate(IX509Certificate certificate) throws ConversionException {
        return (Certificate)ConverterRegistry.get().convert((Object)certificate, Certificate.class);
    }

    public static PrivateKey getPrivateKey(EntityManager entityManager, KeyRef keyRef, Secret password, IPrivateKeyProtection privateKeyProtection) throws IOException, GeneralSecurityException {
        String uri = keyRef.getKeyUri();
        URIResolver resolver = new URIResolver(entityManager, privateKeyProtection, uri);
        return resolver.getPrivateKey(password);
    }

    public static PrivateKey getPrivateKey(Key key, Secret password, IPrivateKeyProtection privateKeyProtection) throws GeneralSecurityException {
        byte[] keyData = key.getKey();
        if (keyData == null) {
            throw new InvalidKeyException("key data not available");
        }
        PrivateKey privateKey = privateKeyProtection.decrypt(new WrappedPrivateKey(keyData, key.getKeyAlgorithm(), key.getEncryptionAlgorithm(), key.getEncryptionAlgorithmParameters()), password);
        return privateKey;
    }

    public static IX509Certificate getX509Certificate(Certificate certificate) throws ConversionException {
        return (IX509Certificate)ConverterRegistry.get().convert((Object)certificate, IX509Certificate.class);
    }

    private DBKeyStoreTools() {
    }
}

