/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.security.virtualkeystore.db.IWrappedPrivateKey;
import de.intarsys.security.virtualkeystore.db.WrappedPrivateKey;
import de.intarsys.tools.crypto.Secret;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.PKCS8EncodedKeySpec;

public class NoopPrivateKeyProtection
implements IPrivateKeyProtection {
    private static final String ALG_NOOP = "noop";

    @Override
    public PrivateKey decrypt(IWrappedPrivateKey wrappedPrivateKey, Secret password) throws GeneralSecurityException {
        if (!ALG_NOOP.equals(wrappedPrivateKey.getEncryptionAlgorithm())) {
            throw new UnrecoverableKeyException("Encrpytion algorithm '" + wrappedPrivateKey.getEncryptionAlgorithm() + "' not supported.");
        }
        KeyFactory factory = KeyFactory.getInstance(wrappedPrivateKey.getKeyAlgorithm(), "BC");
        return factory.generatePrivate(new PKCS8EncodedKeySpec(wrappedPrivateKey.getData()));
    }

    @Override
    public IWrappedPrivateKey encrypt(PrivateKey privateKey, Secret password) throws GeneralSecurityException {
        return new WrappedPrivateKey(privateKey.getEncoded(), privateKey.getAlgorithm(), ALG_NOOP);
    }
}

