/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.certificate.provider.keystore.CommonKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.security.virtualkeystore.resolver.CERResolver;
import de.intarsys.security.virtualkeystore.resolver.JKSResolver;
import de.intarsys.security.virtualkeystore.resolver.PEMResolver;
import de.intarsys.security.virtualkeystore.resolver.PKCS12Resolver;
import de.intarsys.security.virtualkeystore.resolver.PKCS7Resolver;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.url.URLEncodingTools;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ResolverFactory {
    public static IResolver create(ILocator locator, String query) {
        JKSResolver resolver;
        String alias = null;
        if (query != null) {
            try {
                Map queryMap = query == null ? new HashMap() : Converter.asMap((String)query);
                alias = (String)queryMap.get("alias");
                if (alias != null) {
                    alias = URLEncodingTools.decode((String)alias, null);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        if (KeyStoreFacade.isJKS((ILocator)locator)) {
            resolver = new JKSResolver(locator, alias);
            return resolver;
        }
        if (KeyStoreFacade.isPKCS12((ILocator)locator)) {
            resolver = new PKCS12Resolver(locator);
            resolver.setAlias(alias);
            return resolver;
        }
        if (KeyStoreFacade.isCER((ILocator)locator)) {
            resolver = new CERResolver(locator);
            return resolver;
        }
        if (CommonKeyStore.isATZ((ILocator)locator)) {
            resolver = new CERResolver(locator);
            return resolver;
        }
        if (KeyStoreFacade.isPEM((ILocator)locator)) {
            resolver = new PEMResolver(locator);
            return resolver;
        }
        if (KeyStoreFacade.isPKCS7((ILocator)locator)) {
            resolver = new PKCS7Resolver(locator, alias);
            return resolver;
        }
        return null;
    }
}

