/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.virtualkeystore.core.DelegatingResolver;
import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreResolver;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.security.virtualkeystore.db.ResolverFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class URIResolver
extends DelegatingResolver {
    private final EntityManager entityManager;
    private final IPrivateKeyProtection privateKeyProtection;

    public URIResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection) {
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    public URIResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection, ILocator locator) {
        super(locator);
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    public URIResolver(EntityManager entityManager, IPrivateKeyProtection privateKeyProtection, String path) {
        super(path);
        this.entityManager = entityManager;
        this.privateKeyProtection = privateKeyProtection;
    }

    protected IResolver createDelegateResolver() {
        URI fileUri;
        String uriString = this.getPath();
        String query = null;
        try {
            URI uri = new URI(uriString);
            if (DBKeyStoreResolver.supports(uri)) {
                return new DBKeyStoreResolver(this.getEntityManager(), this.getPrivateKeyProtection(), uri.toString().substring(uri.getScheme().length() + 1));
            }
            fileUri = new URI(uriString.substring(0, uriString.indexOf(63)));
            query = uri.getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("uri: " + e);
        }
        File file = new File(fileUri);
        FileLocator locator = new FileLocator(file);
        return ResolverFactory.create((ILocator)locator, query);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public IPrivateKeyProtection getPrivateKeyProtection() {
        return this.privateKeyProtection;
    }

    public String toURI() {
        return this.getPath();
    }
}

