/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.security.virtualkeystore.db.IWrappedPrivateKey;
import de.intarsys.security.virtualkeystore.db.WrappedPrivateKey;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.standard.NullCipherFactory;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.Random;
import javax.crypto.Cipher;

public class WrappingPrivateKeyProtection
implements IPrivateKeyProtection {
    private static final String ALG_WRAP = "wrap";
    private ICipherFactory keyWrapperFactory = new NullCipherFactory();
    private String algorithm = "wrap";

    protected String computeAlgorithm(ICipherFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append(ALG_WRAP);
        sb.append('_');
        sb.append(this.getKeyWrapperFactory().getEncryptionAlgorithmTransformation());
        sb.append('_');
        sb.append(this.getKeyWrapperFactory().getKeySize());
        sb.append('_');
        sb.append(this.getKeyWrapperFactory().getBlockSize());
        return sb.toString();
    }

    @Override
    public PrivateKey decrypt(IWrappedPrivateKey wrappedPrivateKey, Secret password) throws GeneralSecurityException {
        if (!this.getAlgorithm().equals(wrappedPrivateKey.getEncryptionAlgorithm())) {
            throw new UnrecoverableKeyException("Encrpytion algorithm '" + wrappedPrivateKey.getEncryptionAlgorithm() + "' not supported.");
        }
        SecretKeyParameter kekParam = new SecretKeyParameter(wrappedPrivateKey.getEncryptionAlgorithmParameters(), password.getBytes());
        Cipher keyUnwrapper = this.getKeyWrapperFactory().createUnwrap((ICipherParameter)kekParam);
        PrivateKey privateKey = (PrivateKey)keyUnwrapper.unwrap(wrappedPrivateKey.getData(), wrappedPrivateKey.getKeyAlgorithm(), 2);
        return privateKey;
    }

    @Override
    public IWrappedPrivateKey encrypt(PrivateKey privateKey, Secret password) throws GeneralSecurityException {
        byte[] iv = new byte[this.getKeyWrapperFactory().getBlockSize()];
        new Random().nextBytes(iv);
        SecretKeyParameter kekParam = new SecretKeyParameter(iv, password.getBytes());
        Cipher keyWrapper = this.getKeyWrapperFactory().createWrap((ICipherParameter)kekParam);
        byte[] encryptedPrivateKey = keyWrapper.wrap(privateKey);
        return new WrappedPrivateKey(encryptedPrivateKey, privateKey.getAlgorithm(), this.getAlgorithm(), iv);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ICipherFactory getKeyWrapperFactory() {
        return this.keyWrapperFactory;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setKeyWrapperFactory(ICipherFactory keyWrapperFactory) {
        this.keyWrapperFactory = keyWrapperFactory;
        this.setAlgorithm(this.computeAlgorithm(keyWrapperFactory));
    }
}

