/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignatureProperty;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignatureProperty
extends BaseStructure
implements SignatureProperty {
    private final String id;
    private final String target;
    private final List<XMLStructure> content;

    public DOMSignatureProperty(List<? extends XMLStructure> content, String target, String id) {
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        if (content.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        this.content = Collections.unmodifiableList(new ArrayList<XMLStructure>(content));
        int i = 0;
        int size = this.content.size();
        while (i < size) {
            if (!(this.content.get(i) instanceof XMLStructure)) {
                throw new ClassCastException("content[" + i + "] is not a valid type");
            }
            ++i;
        }
        this.target = target;
        this.id = id;
    }

    public DOMSignatureProperty(Element propElem) throws MarshalException {
        this.target = DOMUtils.getAttributeValue(propElem, "Target");
        if (this.target == null) {
            throw new MarshalException("target cannot be null");
        }
        this.id = DOMUtils.getIdAttributeValue(propElem, "Id");
        ArrayList<DOMStructure> newContent = new ArrayList<DOMStructure>();
        Node firstChild = propElem.getFirstChild();
        while (firstChild != null) {
            newContent.add(new DOMStructure(firstChild));
            firstChild = firstChild.getNextSibling();
        }
        if (newContent.isEmpty()) {
            throw new MarshalException("content cannot be empty");
        }
        this.content = Collections.unmodifiableList(newContent);
    }

    @Override
    public List<XMLStructure> getContent() {
        return this.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public static void marshal(XmlWriter xwriter, SignatureProperty sigProp, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "SignatureProperty", "http://www.w3.org/2000/09/xmldsig#");
        xwriter.writeIdAttribute("", "", "Id", sigProp.getId());
        xwriter.writeAttribute("", "", "Target", sigProp.getTarget());
        List<XMLStructure> content = DOMSignatureProperty.getContent(sigProp);
        for (XMLStructure property : content) {
            xwriter.marshalStructure(property, dsPrefix, context);
        }
        xwriter.writeEndElement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperty)) {
            return false;
        }
        SignatureProperty osp = (SignatureProperty)o;
        boolean idsEqual = this.id == null ? osp.getId() == null : this.id.equals(osp.getId());
        List<XMLStructure> ospContent = osp.getContent();
        return this.equalsContent(ospContent) && this.target.equals(osp.getTarget()) && idsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    private static List<XMLStructure> getContent(SignatureProperty prop) {
        return prop.getContent();
    }

    private boolean equalsContent(List<XMLStructure> otherContent) {
        int osize = otherContent.size();
        if (this.content.size() != osize) {
            return false;
        }
        int i = 0;
        while (i < osize) {
            XMLStructure oxs = otherContent.get(i);
            XMLStructure xs = this.content.get(i);
            if (oxs instanceof DOMStructure) {
                if (!(xs instanceof DOMStructure)) {
                    return false;
                }
                Node onode = ((DOMStructure)oxs).getNode();
                Node node = ((DOMStructure)xs).getNode();
                if (!DOMUtils.nodesEqual(node, onode)) {
                    return false;
                }
            } else if (!xs.equals(oxs)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

