/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlWriterToTree
implements XmlWriter {
    private Document factory;
    private Element createdElement;
    private Node nextSibling;
    private Node currentNode;
    private List<XmlWriter.ToMarshal<? extends XMLStructure>> m_marshallers;

    public XmlWriterToTree(List<XmlWriter.ToMarshal<? extends XMLStructure>> marshallers, Node parent) {
        this.m_marshallers = marshallers;
        this.factory = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        this.currentNode = parent;
    }

    public void resetToNewParent(Node newParent) {
        this.currentNode = newParent;
        this.createdElement = null;
    }

    public Element getCreatedElement() {
        return this.createdElement;
    }

    public XmlWriterToTree(List<XmlWriter.ToMarshal<? extends XMLStructure>> marshallers, Node parent, Node nextSibling) {
        this(marshallers, parent);
        this.nextSibling = nextSibling;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        Element newElem = this.factory.createElementNS(namespaceURI, DOMUtils.getQNameString(prefix, localName));
        newElem = this.nextSibling != null ? (Element)this.nextSibling.getParentNode().insertBefore(newElem, this.nextSibling) : (Element)this.currentNode.appendChild(newElem);
        this.nextSibling = null;
        this.currentNode = newElem;
        if (this.createdElement == null) {
            this.createdElement = newElem;
        }
    }

    @Override
    public void writeEndElement() {
        this.currentNode = this.currentNode.getParentNode();
    }

    @Override
    public void writeTextElement(String prefix, String localName, String namespaceURI, String value) {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        if ("".equals(prefix) || prefix == null) {
            this.writeAttribute(null, "http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns", "http://www.w3.org/2000/xmlns/", prefix, namespaceURI);
        }
    }

    @Override
    public void writeCharacters(String text) {
        Text textNode = this.factory.createTextNode(text);
        this.currentNode.appendChild(textNode);
    }

    @Override
    public void writeComment(String text) {
        Comment commentNode = this.factory.createComment(text);
        this.currentNode.appendChild(commentNode);
    }

    @Override
    public Attr writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        Attr result = null;
        if (value != null) {
            if ("".equals(namespaceURI)) {
                namespaceURI = null;
            }
            result = this.factory.createAttributeNS(namespaceURI, DOMUtils.getQNameString(prefix, localName));
            result.setTextContent(value);
            if (!(this.currentNode instanceof Element)) {
                throw new IllegalStateException("Attempting to add an attribute to something other than an element node. Node is " + this.currentNode.toString());
            }
            ((Element)this.currentNode).setAttributeNodeNS(result);
        }
        return result;
    }

    @Override
    public void writeIdAttribute(String prefix, String namespaceURI, String localName, String value) {
        if (value == null) {
            return;
        }
        Attr newAttr = this.writeAttribute(prefix, namespaceURI, localName, value);
        ((Element)this.currentNode).setIdAttributeNode(newAttr, true);
    }

    @Override
    public String getCurrentLocalName() {
        return this.currentNode.getLocalName();
    }

    @Override
    public XMLStructure getCurrentNodeAsStructure() {
        return new DOMStructure(this.currentNode);
    }

    @Override
    public void marshalStructure(XMLStructure toMarshal, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        int idx = 0;
        while (idx < this.m_marshallers.size()) {
            XmlWriter.ToMarshal<? extends XMLStructure> marshaller = this.m_marshallers.get(idx);
            if (marshaller.clazzToMatch.isInstance(toMarshal)) {
                marshaller.marshalObject(this, toMarshal, dsPrefix, context);
                return;
            }
            ++idx;
        }
        throw new IllegalArgumentException("Unable to marshal unexpected object of class " + toMarshal.getClass().toString());
    }
}

