/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static Logger log = LoggerFactory.getLogger(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                String cfile = System.getProperty("org.apache.xml.security.resource.config");
                if (cfile == null) {
                    return null;
                }
                return this.getClass().getResourceAsStream(cfile);
            }
        });
        if (is == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(is);
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        if (log.isDebugEnabled()) {
            log.debug("Registering default algorithms");
        }
        try {
            ElementProxy.registerDefaultPrefixes();
        }
        catch (XMLSecurityException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        Transform.registerDefaultAlgorithms();
        SignatureAlgorithm.registerDefaultAlgorithms();
        JCEMapper.registerDefaultAlgorithms();
        Canonicalizer.registerDefaultAlgorithms();
        ResourceResolver.registerDefaultResolvers();
        KeyResolver.registerDefaultResolvers();
    }

    private static void fileInit(InputStream is) {
        try {
            DocumentBuilder db = XMLUtils.createDocumentBuilder(false);
            Document doc = db.parse(is);
            Node config = doc.getFirstChild();
            while (config != null) {
                if ("Configuration".equals(config.getLocalName())) break;
                config = config.getNextSibling();
            }
            if (config == null) {
                log.error("Error in reading configuration file - Configuration element not found");
                return;
            }
            Node el = config.getFirstChild();
            while (el != null) {
                if (1 == el.getNodeType()) {
                    Object javaClass;
                    Element[] resolverElem;
                    Node algorithmsNode;
                    Object[] exArgs;
                    String javaClass2;
                    Object uri;
                    Element element;
                    Element[] elementArray;
                    String tag = el.getLocalName();
                    if (tag.equals("ResourceBundles")) {
                        Element resource = (Element)el;
                        Attr langAttr = resource.getAttributeNodeNS(null, "defaultLanguageCode");
                        Attr countryAttr = resource.getAttributeNodeNS(null, "defaultCountryCode");
                        String languageCode = langAttr == null ? null : langAttr.getNodeValue();
                        String countryCode = countryAttr == null ? null : countryAttr.getNodeValue();
                        I18n.init(languageCode, countryCode);
                    }
                    if (tag.equals("CanonicalizationMethods")) {
                        Element[] list;
                        elementArray = list = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "CanonicalizationMethod");
                        int n = list.length;
                        int countryAttr = 0;
                        while (countryAttr < n) {
                            element = elementArray[countryAttr];
                            uri = element.getAttributeNS(null, "URI");
                            javaClass2 = element.getAttributeNS(null, "JAVACLASS");
                            try {
                                Canonicalizer.register((String)uri, javaClass2);
                                if (log.isDebugEnabled()) {
                                    log.debug("Canonicalizer.register(" + (String)uri + ", " + javaClass2 + ")");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{uri, javaClass2};
                                log.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            ++countryAttr;
                        }
                    }
                    if (tag.equals("TransformAlgorithms")) {
                        Element[] tranElem;
                        elementArray = tranElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "TransformAlgorithm");
                        int n = tranElem.length;
                        int countryAttr = 0;
                        while (countryAttr < n) {
                            element = elementArray[countryAttr];
                            uri = element.getAttributeNS(null, "URI");
                            javaClass2 = element.getAttributeNS(null, "JAVACLASS");
                            try {
                                Transform.register((String)uri, javaClass2);
                                if (log.isDebugEnabled()) {
                                    log.debug("Transform.register(" + (String)uri + ", " + javaClass2 + ")");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{uri, javaClass2};
                                log.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            catch (NoClassDefFoundError ex) {
                                log.warn("Not able to found dependencies for algorithm, I'll keep working.");
                            }
                            ++countryAttr;
                        }
                    }
                    if ("JCEAlgorithmMappings".equals(tag) && (algorithmsNode = ((Element)el).getElementsByTagName("Algorithms").item(0)) != null) {
                        Element[] algorithms;
                        uri = algorithms = XMLUtils.selectNodes(algorithmsNode.getFirstChild(), CONF_NS, "Algorithm");
                        int n = algorithms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Element element2 = uri[n2];
                            String id = element2.getAttributeNS(null, "URI");
                            JCEMapper.register(id, new JCEMapper.Algorithm(element2));
                            ++n2;
                        }
                    }
                    if (tag.equals("SignatureAlgorithms")) {
                        Element[] sigElems;
                        Element[] elementArray2 = sigElems = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                        int n = sigElems.length;
                        int element2 = 0;
                        while (element2 < n) {
                            Element sigElem = elementArray2[element2];
                            uri = sigElem.getAttributeNS(null, "URI");
                            javaClass2 = sigElem.getAttributeNS(null, "JAVACLASS");
                            try {
                                SignatureAlgorithm.register((String)uri, javaClass2);
                                if (log.isDebugEnabled()) {
                                    log.debug("SignatureAlgorithm.register(" + (String)uri + ", " + javaClass2 + ")");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                exArgs = new Object[]{uri, javaClass2};
                                log.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                            }
                            ++element2;
                        }
                    }
                    if (tag.equals("ResourceResolvers")) {
                        Element[] elementArray3 = resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                        int n = resolverElem.length;
                        int element2 = 0;
                        while (element2 < n) {
                            element = elementArray3[element2];
                            javaClass = element.getAttributeNS(null, "JAVACLASS");
                            String description = element.getAttributeNS(null, "DESCRIPTION");
                            if (description != null && description.length() > 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Register Resolver: " + (String)javaClass + ": " + description);
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + (String)javaClass + ": For unknown purposes");
                            }
                            try {
                                ResourceResolver.register((String)javaClass);
                            }
                            catch (Throwable e) {
                                log.warn("Cannot register:" + (String)javaClass + " perhaps some needed jars are not installed", e);
                            }
                            ++element2;
                        }
                    }
                    if (tag.equals("KeyResolver")) {
                        resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                        ArrayList<String> classNames = new ArrayList<String>(resolverElem.length);
                        javaClass = resolverElem;
                        int n = resolverElem.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Element element3 = javaClass[n3];
                            javaClass2 = element3.getAttributeNS(null, "JAVACLASS");
                            String description = element3.getAttributeNS(null, "DESCRIPTION");
                            if (description != null && description.length() > 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Register Resolver: " + javaClass2 + ": " + description);
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("Register Resolver: " + javaClass2 + ": For unknown purposes");
                            }
                            classNames.add(javaClass2);
                            ++n3;
                        }
                        KeyResolver.registerClassNames(classNames);
                    }
                    if (tag.equals("PrefixMappings")) {
                        Element[] nl;
                        if (log.isDebugEnabled()) {
                            log.debug("Now I try to bind prefixes:");
                        }
                        Element[] elementArray4 = nl = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "PrefixMapping");
                        int n = nl.length;
                        int n4 = 0;
                        while (n4 < n) {
                            element = elementArray4[n4];
                            String namespace = element.getAttributeNS(null, "namespace");
                            String prefix = element.getAttributeNS(null, "prefix");
                            if (log.isDebugEnabled()) {
                                log.debug("Now I try to bind " + prefix + " to " + namespace);
                            }
                            ElementProxy.setDefaultPrefix(namespace, prefix);
                            ++n4;
                        }
                    }
                }
                el = el.getNextSibling();
            }
        }
        catch (Exception e) {
            log.error("Bad: ", (Throwable)e);
        }
    }
}

