/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    private static Logger log = LoggerFactory.getLogger(RSAKeyValueResolver.class);
    private Key kek;
    private String algorithm;
    private List<KeyResolverSpi> internalKeyResolvers;

    public EncryptedKeyResolver(String algorithm) {
        this.kek = null;
        this.algorithm = algorithm;
    }

    public EncryptedKeyResolver(String algorithm, Key kek) {
        this.algorithm = algorithm;
        this.kek = kek;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        if (this.internalKeyResolvers == null) {
            this.internalKeyResolvers = new ArrayList<KeyResolverSpi>();
        }
        this.internalKeyResolvers.add(realKeyResolver);
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String baseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String baseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String baseURI, StorageResolver storage) {
        SecretKey key;
        block8: {
            if (element == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("EncryptedKeyResolver - Can I resolve " + element.getTagName());
            }
            key = null;
            boolean isEncryptedKey = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
            if (isEncryptedKey) {
                if (log.isDebugEnabled()) {
                    log.debug("Passed an Encrypted Key");
                }
                try {
                    XMLCipher cipher = XMLCipher.getInstance();
                    cipher.init(4, this.kek);
                    if (this.internalKeyResolvers != null) {
                        int size = this.internalKeyResolvers.size();
                        int i = 0;
                        while (i < size) {
                            cipher.registerInternalKeyResolver(this.internalKeyResolvers.get(i));
                            ++i;
                        }
                    }
                    EncryptedKey ek = cipher.loadEncryptedKey(element);
                    key = (SecretKey)cipher.decryptKey(ek, this.algorithm);
                }
                catch (XMLEncryptionException e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return key;
    }
}

