/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProperties
extends SignatureElementProxy {
    public SignatureProperties(Document doc) {
        super(doc);
        this.addReturnToSelf();
    }

    public SignatureProperties(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
        int length = this.getLength();
        int i = 0;
        while (i < length) {
            Element propertyElem = XMLUtils.selectDsNode(this.getElement(), "SignatureProperty", i);
            Attr propertyAttr = propertyElem.getAttributeNodeNS(null, "Id");
            if (propertyAttr != null) {
                propertyElem.setIdAttributeNode(propertyAttr, true);
            }
            ++i;
        }
    }

    public int getLength() {
        Element[] propertyElems = XMLUtils.selectDsNodes(this.getElement(), "SignatureProperty");
        return propertyElems.length;
    }

    public SignatureProperty item(int i) throws XMLSignatureException {
        Element propertyElem;
        block3: {
            try {
                propertyElem = XMLUtils.selectDsNode(this.getElement(), "SignatureProperty", i);
                if (propertyElem != null) break block3;
                return null;
            }
            catch (XMLSecurityException ex) {
                throw new XMLSignatureException(ex);
            }
        }
        return new SignatureProperty(propertyElem, this.baseURI);
    }

    public void setId(String Id) {
        if (Id != null) {
            this.setLocalIdAttribute("Id", Id);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public void addSignatureProperty(SignatureProperty sp) {
        this.appendSelf(sp);
        this.addReturnToSelf();
    }

    @Override
    public String getBaseLocalName() {
        return "SignatureProperties";
    }
}

