/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.DocumentContext;
import org.apache.xml.security.stax.ext.InboundSecurityContext;
import org.apache.xml.security.stax.ext.InputProcessor;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.DocumentContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputProcessorChainImpl
implements InputProcessorChain {
    protected static final transient Logger log = LoggerFactory.getLogger(InputProcessorChainImpl.class);
    protected static final transient boolean isDebugEnabled = log.isDebugEnabled();
    private List<InputProcessor> inputProcessors;
    private int startPos = 0;
    private int curPos = 0;
    private final InboundSecurityContext inboundSecurityContext;
    private final DocumentContextImpl documentContext;

    public InputProcessorChainImpl(InboundSecurityContext inboundSecurityContext) {
        this(inboundSecurityContext, 0);
    }

    public InputProcessorChainImpl(InboundSecurityContext inboundSecurityContext, int startPos) {
        this(inboundSecurityContext, new DocumentContextImpl(), startPos, new ArrayList<InputProcessor>(20));
    }

    public InputProcessorChainImpl(InboundSecurityContext inboundSecurityContext, DocumentContextImpl documentContext) {
        this(inboundSecurityContext, documentContext, 0, new ArrayList<InputProcessor>(20));
    }

    protected InputProcessorChainImpl(InboundSecurityContext inboundSecurityContext, DocumentContextImpl documentContextImpl, int startPos, List<InputProcessor> inputProcessors) {
        this.inboundSecurityContext = inboundSecurityContext;
        this.curPos = this.startPos = startPos;
        this.documentContext = documentContextImpl;
        this.inputProcessors = inputProcessors;
    }

    @Override
    public void reset() {
        this.curPos = this.startPos;
    }

    @Override
    public InboundSecurityContext getSecurityContext() {
        return this.inboundSecurityContext;
    }

    @Override
    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    @Override
    public synchronized void addProcessor(InputProcessor newInputProcessor) {
        int idxToInsert;
        InputProcessor inputProcessor;
        int startPhaseIdx = 0;
        int endPhaseIdx = this.inputProcessors.size();
        XMLSecurityConstants.Phase targetPhase = newInputProcessor.getPhase();
        int i = this.inputProcessors.size() - 1;
        while (i >= 0) {
            inputProcessor = this.inputProcessors.get(i);
            if (inputProcessor.getPhase().ordinal() > targetPhase.ordinal()) {
                startPhaseIdx = i + 1;
                break;
            }
            --i;
        }
        i = startPhaseIdx;
        while (i < this.inputProcessors.size()) {
            inputProcessor = this.inputProcessors.get(i);
            if (inputProcessor.getPhase().ordinal() < targetPhase.ordinal()) {
                endPhaseIdx = i;
                break;
            }
            ++i;
        }
        if (newInputProcessor.getBeforeProcessors().isEmpty() && newInputProcessor.getAfterProcessors().isEmpty()) {
            this.inputProcessors.add(startPhaseIdx, newInputProcessor);
        } else if (newInputProcessor.getBeforeProcessors().isEmpty()) {
            idxToInsert = startPhaseIdx;
            int i2 = endPhaseIdx - 1;
            while (i2 >= startPhaseIdx) {
                InputProcessor inputProcessor2 = this.inputProcessors.get(i2);
                if (newInputProcessor.getAfterProcessors().contains(inputProcessor2) || newInputProcessor.getAfterProcessors().contains(inputProcessor2.getClass().getName())) {
                    idxToInsert = i2;
                    break;
                }
                --i2;
            }
            this.inputProcessors.add(idxToInsert, newInputProcessor);
        } else if (newInputProcessor.getAfterProcessors().isEmpty()) {
            idxToInsert = endPhaseIdx;
            int i3 = startPhaseIdx;
            while (i3 < endPhaseIdx) {
                InputProcessor inputProcessor3 = this.inputProcessors.get(i3);
                if (newInputProcessor.getBeforeProcessors().contains(inputProcessor3) || newInputProcessor.getBeforeProcessors().contains(inputProcessor3.getClass().getName())) {
                    idxToInsert = i3 + 1;
                    break;
                }
                ++i3;
            }
            this.inputProcessors.add(idxToInsert, newInputProcessor);
        } else {
            InputProcessor inputProcessor4;
            boolean found = false;
            int idxToInsert2 = startPhaseIdx;
            int i4 = endPhaseIdx - 1;
            while (i4 >= startPhaseIdx) {
                inputProcessor4 = this.inputProcessors.get(i4);
                if (newInputProcessor.getAfterProcessors().contains(inputProcessor4) || newInputProcessor.getAfterProcessors().contains(inputProcessor4.getClass().getName())) {
                    idxToInsert2 = i4;
                    found = true;
                    break;
                }
                --i4;
            }
            if (found) {
                this.inputProcessors.add(idxToInsert2, newInputProcessor);
            } else {
                i4 = startPhaseIdx;
                while (i4 < endPhaseIdx) {
                    inputProcessor4 = this.inputProcessors.get(i4);
                    if (newInputProcessor.getBeforeProcessors().contains(inputProcessor4) || newInputProcessor.getBeforeProcessors().contains(inputProcessor4.getClass().getName())) {
                        idxToInsert2 = i4 + 1;
                        break;
                    }
                    ++i4;
                }
                this.inputProcessors.add(idxToInsert2, newInputProcessor);
            }
        }
        if (isDebugEnabled) {
            log.debug("Added " + newInputProcessor.getClass().getName() + " to input chain: ");
            i = 0;
            while (i < this.inputProcessors.size()) {
                InputProcessor inputProcessor5 = this.inputProcessors.get(i);
                log.debug("Name: " + inputProcessor5.getClass().getName() + " phase: " + (Object)((Object)inputProcessor5.getPhase()));
                ++i;
            }
        }
    }

    @Override
    public synchronized void removeProcessor(InputProcessor inputProcessor) {
        if (isDebugEnabled) {
            log.debug("Removing processor " + inputProcessor.getClass().getName() + " from input chain");
        }
        if (this.inputProcessors.indexOf(inputProcessor) <= this.curPos) {
            --this.curPos;
        }
        this.inputProcessors.remove(inputProcessor);
    }

    @Override
    public List<InputProcessor> getProcessors() {
        return this.inputProcessors;
    }

    @Override
    public XMLSecEvent processHeaderEvent() throws XMLStreamException, XMLSecurityException {
        return this.inputProcessors.get(this.curPos++).processNextHeaderEvent(this);
    }

    @Override
    public XMLSecEvent processEvent() throws XMLStreamException, XMLSecurityException {
        return this.inputProcessors.get(this.curPos++).processNextEvent(this);
    }

    @Override
    public void doFinal() throws XMLStreamException, XMLSecurityException {
        this.inputProcessors.get(this.curPos++).doFinal(this);
    }

    @Override
    public InputProcessorChain createSubChain(InputProcessor inputProcessor) throws XMLStreamException, XMLSecurityException {
        return this.createSubChain(inputProcessor, true);
    }

    @Override
    public InputProcessorChain createSubChain(InputProcessor inputProcessor, boolean clone) throws XMLStreamException, XMLSecurityException {
        InputProcessorChainImpl inputProcessorChain;
        try {
            DocumentContextImpl docContext = clone ? this.documentContext.clone() : this.documentContext;
            inputProcessorChain = new InputProcessorChainImpl(this.inboundSecurityContext, docContext, this.inputProcessors.indexOf(inputProcessor) + 1, new ArrayList<InputProcessor>(this.inputProcessors));
        }
        catch (CloneNotSupportedException e) {
            throw new XMLSecurityException(e);
        }
        return inputProcessorChain;
    }
}

