/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.DocumentContext;
import org.apache.xml.security.stax.ext.OutboundSecurityContext;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.DocumentContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessorChainImpl
implements OutputProcessorChain {
    protected static final transient Logger log = LoggerFactory.getLogger(OutputProcessorChainImpl.class);
    protected static final transient boolean isDebugEnabled = log.isDebugEnabled();
    private List<OutputProcessor> outputProcessors;
    private int startPos = 0;
    private int curPos = 0;
    private XMLSecStartElement parentXmlSecStartElement;
    private final OutboundSecurityContext outboundSecurityContext;
    private final DocumentContextImpl documentContext;

    public OutputProcessorChainImpl(OutboundSecurityContext outboundSecurityContext) {
        this(outboundSecurityContext, 0);
    }

    public OutputProcessorChainImpl(OutboundSecurityContext outboundSecurityContext, int startPos) {
        this(outboundSecurityContext, new DocumentContextImpl(), startPos, new ArrayList<OutputProcessor>(20));
    }

    public OutputProcessorChainImpl(OutboundSecurityContext outboundSecurityContext, DocumentContextImpl documentContext) {
        this(outboundSecurityContext, documentContext, 0, new ArrayList<OutputProcessor>(20));
    }

    protected OutputProcessorChainImpl(OutboundSecurityContext outboundSecurityContext, DocumentContextImpl documentContextImpl, int startPos, List<OutputProcessor> outputProcessors) {
        this.outboundSecurityContext = outboundSecurityContext;
        this.curPos = this.startPos = startPos;
        this.documentContext = documentContextImpl;
        this.outputProcessors = outputProcessors;
    }

    @Override
    public void reset() {
        this.curPos = this.startPos;
    }

    @Override
    public OutboundSecurityContext getSecurityContext() {
        return this.outboundSecurityContext;
    }

    @Override
    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    @Override
    public void addProcessor(OutputProcessor newOutputProcessor) {
        OutputProcessor outputProcessor;
        int endPhaseIdx;
        int startPhaseIdx = 0;
        int idxToInsert = endPhaseIdx = this.outputProcessors.size();
        XMLSecurityConstants.Phase targetPhase = newOutputProcessor.getPhase();
        int i = this.outputProcessors.size() - 1;
        while (i >= 0) {
            outputProcessor = this.outputProcessors.get(i);
            if (outputProcessor.getPhase().ordinal() < targetPhase.ordinal()) {
                startPhaseIdx = i + 1;
                break;
            }
            --i;
        }
        i = startPhaseIdx;
        while (i < this.outputProcessors.size()) {
            outputProcessor = this.outputProcessors.get(i);
            if (outputProcessor.getPhase().ordinal() > targetPhase.ordinal()) {
                endPhaseIdx = i;
                break;
            }
            ++i;
        }
        if (newOutputProcessor.getBeforeProcessors().isEmpty() && newOutputProcessor.getAfterProcessors().isEmpty()) {
            this.outputProcessors.add(endPhaseIdx, newOutputProcessor);
        } else if (newOutputProcessor.getBeforeProcessors().isEmpty()) {
            idxToInsert = endPhaseIdx;
            i = endPhaseIdx - 1;
            while (i >= startPhaseIdx) {
                outputProcessor = this.outputProcessors.get(i);
                if (newOutputProcessor.getAfterProcessors().contains(outputProcessor) || newOutputProcessor.getAfterProcessors().contains(outputProcessor.getClass().getName())) {
                    idxToInsert = i + 1;
                    break;
                }
                --i;
            }
            this.outputProcessors.add(idxToInsert, newOutputProcessor);
        } else if (newOutputProcessor.getAfterProcessors().isEmpty()) {
            idxToInsert = startPhaseIdx;
            i = startPhaseIdx;
            while (i < endPhaseIdx) {
                outputProcessor = this.outputProcessors.get(i);
                if (newOutputProcessor.getBeforeProcessors().contains(outputProcessor) || newOutputProcessor.getBeforeProcessors().contains(outputProcessor.getClass().getName())) {
                    idxToInsert = i;
                    break;
                }
                ++i;
            }
            this.outputProcessors.add(idxToInsert, newOutputProcessor);
        } else {
            OutputProcessor outputProcessor2;
            boolean found = false;
            idxToInsert = endPhaseIdx;
            int i2 = startPhaseIdx;
            while (i2 < endPhaseIdx) {
                outputProcessor2 = this.outputProcessors.get(i2);
                if (newOutputProcessor.getBeforeProcessors().contains(outputProcessor2) || newOutputProcessor.getBeforeProcessors().contains(outputProcessor2.getClass().getName())) {
                    idxToInsert = i2;
                    found = true;
                    break;
                }
                ++i2;
            }
            if (found) {
                this.outputProcessors.add(idxToInsert, newOutputProcessor);
            } else {
                i2 = endPhaseIdx - 1;
                while (i2 >= startPhaseIdx) {
                    outputProcessor2 = this.outputProcessors.get(i2);
                    if (newOutputProcessor.getAfterProcessors().contains(outputProcessor2) || newOutputProcessor.getAfterProcessors().contains(outputProcessor2.getClass().getName())) {
                        idxToInsert = i2 + 1;
                        break;
                    }
                    --i2;
                }
                this.outputProcessors.add(idxToInsert, newOutputProcessor);
            }
        }
        if (idxToInsert < this.curPos) {
            ++this.curPos;
        }
        if (isDebugEnabled) {
            log.debug("Added " + newOutputProcessor.getClass().getName() + " to output chain: ");
            i = 0;
            while (i < this.outputProcessors.size()) {
                OutputProcessor outputProcessor3 = this.outputProcessors.get(i);
                log.debug("Name: " + outputProcessor3.getClass().getName() + " phase: " + (Object)((Object)outputProcessor3.getPhase()));
                ++i;
            }
        }
    }

    @Override
    public void removeProcessor(OutputProcessor outputProcessor) {
        if (isDebugEnabled) {
            log.debug("Removing processor " + outputProcessor.getClass().getName() + " from output chain");
        }
        if (this.outputProcessors.indexOf(outputProcessor) <= this.curPos) {
            --this.curPos;
        }
        this.outputProcessors.remove(outputProcessor);
    }

    @Override
    public List<OutputProcessor> getProcessors() {
        return this.outputProcessors;
    }

    private void setParentXmlSecStartElement(XMLSecStartElement xmlSecStartElement) {
        this.parentXmlSecStartElement = xmlSecStartElement;
    }

    @Override
    public void processEvent(XMLSecEvent xmlSecEvent) throws XMLStreamException, XMLSecurityException {
        boolean reparent = false;
        if (this.curPos == this.startPos) {
            switch (xmlSecEvent.getEventType()) {
                case 1: {
                    if (xmlSecEvent == this.parentXmlSecStartElement) {
                        this.parentXmlSecStartElement = null;
                    }
                    xmlSecEvent.setParentXMLSecStartElement(this.parentXmlSecStartElement);
                    this.parentXmlSecStartElement = xmlSecEvent.asStartElement();
                    break;
                }
                case 2: {
                    xmlSecEvent.setParentXMLSecStartElement(this.parentXmlSecStartElement);
                    reparent = true;
                    break;
                }
                default: {
                    xmlSecEvent.setParentXMLSecStartElement(this.parentXmlSecStartElement);
                }
            }
        }
        this.outputProcessors.get(this.curPos++).processNextEvent(xmlSecEvent, this);
        if (reparent && this.parentXmlSecStartElement != null) {
            this.parentXmlSecStartElement = this.parentXmlSecStartElement.getParentXMLSecStartElement();
        }
    }

    @Override
    public void doFinal() throws XMLStreamException, XMLSecurityException {
        this.outputProcessors.get(this.curPos++).doFinal(this);
    }

    @Override
    public OutputProcessorChain createSubChain(OutputProcessor outputProcessor) throws XMLStreamException, XMLSecurityException {
        return this.createSubChain(outputProcessor, null);
    }

    @Override
    public OutputProcessorChain createSubChain(OutputProcessor outputProcessor, XMLSecStartElement parentXMLSecStartElement) throws XMLStreamException, XMLSecurityException {
        OutputProcessorChainImpl outputProcessorChain;
        try {
            outputProcessorChain = new OutputProcessorChainImpl(this.outboundSecurityContext, this.documentContext.clone(), this.outputProcessors.indexOf(outputProcessor) + 1, this.outputProcessors);
        }
        catch (CloneNotSupportedException e) {
            throw new XMLSecurityException(e);
        }
        if (parentXMLSecStartElement != null) {
            outputProcessorChain.setParentXmlSecStartElement(parentXMLSecStartElement);
        } else {
            outputProcessorChain.setParentXmlSecStartElement(this.parentXmlSecStartElement);
        }
        return outputProcessorChain;
    }
}

