/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.transformer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.processor.input.XMLEventReaderInputProcessor;
import org.apache.xml.security.stax.impl.transformer.TransformIdentity;
import org.apache.xml.security.stax.impl.util.UnsynchronizedByteArrayInputStream;
import org.apache.xml.security.stax.impl.util.UnsynchronizedByteArrayOutputStream;

public class TransformBase64Decode
extends TransformIdentity {
    private TransformIdentity.ChildOutputMethod childOutputMethod;

    @Override
    public void setOutputStream(OutputStream outputStream) throws XMLSecurityException {
        super.setOutputStream((OutputStream)new Base64OutputStream((OutputStream)new FilterOutputStream(outputStream){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        }, false));
    }

    @Override
    public XMLSecurityConstants.TransformMethod getPreferredTransformMethod(XMLSecurityConstants.TransformMethod forInput) {
        switch (forInput) {
            case XMLSecEvent: {
                return XMLSecurityConstants.TransformMethod.InputStream;
            }
            case InputStream: {
                return XMLSecurityConstants.TransformMethod.InputStream;
            }
        }
        throw new IllegalArgumentException("Unsupported class " + forInput.name());
    }

    @Override
    public void transform(XMLSecEvent xmlSecEvent) throws XMLStreamException {
        int eventType = xmlSecEvent.getEventType();
        switch (eventType) {
            case 4: {
                if (this.getOutputStream() != null) {
                    try {
                        this.getOutputStream().write(xmlSecEvent.asCharacters().getData().getBytes());
                        break;
                    }
                    catch (IOException e) {
                        throw new XMLStreamException(e);
                    }
                }
                if (this.childOutputMethod == null) {
                    XMLSecurityConstants.TransformMethod preferredChildTransformMethod = this.getTransformer().getPreferredTransformMethod(XMLSecurityConstants.TransformMethod.XMLSecEvent);
                    switch (preferredChildTransformMethod) {
                        case XMLSecEvent: {
                            this.childOutputMethod = new TransformIdentity.ChildOutputMethod(){
                                private UnsynchronizedByteArrayOutputStream byteArrayOutputStream;
                                private Base64OutputStream base64OutputStream;

                                @Override
                                public void transform(Object object) throws XMLStreamException {
                                    if (this.base64OutputStream == null) {
                                        this.byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
                                        this.base64OutputStream = new Base64OutputStream((OutputStream)this.byteArrayOutputStream, false);
                                    }
                                    try {
                                        this.base64OutputStream.write((byte[])object);
                                    }
                                    catch (IOException e) {
                                        throw new XMLStreamException(e);
                                    }
                                }

                                @Override
                                public void doFinal() throws XMLStreamException {
                                    try {
                                        this.base64OutputStream.close();
                                    }
                                    catch (IOException e) {
                                        throw new XMLStreamException(e);
                                    }
                                    XMLEventReaderInputProcessor xmlEventReaderInputProcessor = new XMLEventReaderInputProcessor(null, TransformBase64Decode.getXmlInputFactory().createXMLStreamReader(new UnsynchronizedByteArrayInputStream(this.byteArrayOutputStream.toByteArray())));
                                    try {
                                        XMLSecEvent xmlSecEvent;
                                        do {
                                            xmlSecEvent = xmlEventReaderInputProcessor.processNextEvent(null);
                                            TransformBase64Decode.this.getTransformer().transform(xmlSecEvent);
                                        } while (xmlSecEvent.getEventType() != 8);
                                    }
                                    catch (XMLSecurityException e) {
                                        throw new XMLStreamException(e);
                                    }
                                    TransformBase64Decode.this.getTransformer().doFinal();
                                }
                            };
                            break;
                        }
                        case InputStream: {
                            this.childOutputMethod = new TransformIdentity.ChildOutputMethod(){
                                private UnsynchronizedByteArrayOutputStream byteArrayOutputStream;
                                private Base64OutputStream base64OutputStream;

                                @Override
                                public void transform(Object object) throws XMLStreamException {
                                    if (this.base64OutputStream == null) {
                                        this.byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
                                        this.base64OutputStream = new Base64OutputStream((OutputStream)this.byteArrayOutputStream, false);
                                    }
                                    try {
                                        this.base64OutputStream.write((byte[])object);
                                    }
                                    catch (IOException e) {
                                        throw new XMLStreamException(e);
                                    }
                                }

                                @Override
                                public void doFinal() throws XMLStreamException {
                                    try {
                                        this.base64OutputStream.close();
                                    }
                                    catch (IOException e) {
                                        throw new XMLStreamException(e);
                                    }
                                    TransformBase64Decode.this.getTransformer().transform(new UnsynchronizedByteArrayInputStream(this.byteArrayOutputStream.toByteArray()));
                                    TransformBase64Decode.this.getTransformer().doFinal();
                                }
                            };
                        }
                    }
                }
                this.childOutputMethod.transform(xmlSecEvent.asCharacters().getData().getBytes());
            }
        }
    }

    @Override
    public void transform(InputStream inputStream) throws XMLStreamException {
        if (this.getOutputStream() != null) {
            super.transform(inputStream);
        } else {
            super.transform((InputStream)new Base64InputStream(inputStream, false));
        }
    }

    @Override
    public void doFinal() throws XMLStreamException {
        if (this.getOutputStream() != null) {
            try {
                this.getOutputStream().close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
        if (this.childOutputMethod != null) {
            this.childOutputMethod.doFinal();
        } else if (this.getTransformer() != null) {
            this.getTransformer().doFinal();
        }
    }
}

