/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.util;

import java.io.IOException;
import java.io.InputStream;

public class MultiInputStream
extends InputStream {
    private final InputStream[] inputStreams;
    private final int inputStreamCount;
    private int inputStreamIndex = 0;

    public MultiInputStream(InputStream ... inputStreams) {
        this.inputStreams = inputStreams;
        this.inputStreamCount = inputStreams.length;
    }

    @Override
    public int read() throws IOException {
        int i = this.inputStreamIndex;
        while (i < this.inputStreamCount) {
            int b = this.inputStreams[i].read();
            if (b >= 0) {
                return b;
            }
            ++this.inputStreamIndex;
            ++i;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.inputStreamIndex;
        while (i < this.inputStreamCount) {
            int read = this.inputStreams[i].read(b, off, len);
            if (read >= 0) {
                return read;
            }
            ++this.inputStreamIndex;
            ++i;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip() not supported");
    }

    @Override
    public int available() throws IOException {
        if (this.inputStreamIndex < this.inputStreamCount) {
            return this.inputStreams[this.inputStreamIndex].available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        int i = 0;
        while (i < this.inputStreamCount) {
            try {
                this.inputStreams[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }
}

