/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.xml.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.security.document.type.xml.signature.PACKAGE;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.processor.signature.DeviceBasedDocumentSigner;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.Tag;
import java.util.List;

public abstract class AbstractXMLDocumentSigner
extends DeviceBasedDocumentSigner {
    public static final String ARG_FORMAT = "format";
    public static final String ARG_NAMESPACES = "namespaces";
    public static final String ARG_PARENTNODECREATE = "parentNodeCreate";
    public static final String ARG_PARENTNODELOOKUP = "parentNodeLookup";
    public static final String ARG_REFERENCES = "references";
    public static final String ARG_SIGNATUREELEMENTID = "signatureElementId";
    public static final String REFERENCE_TRANSFORMS = "transforms";
    public static final String REFERENCE_URI = "uri";
    public static final String TRANSFORM_ALGORITHM = "algorithm";
    public static final String TRANSFORM_EXPRESSION = "expression";
    public static final String TRANSFORM_FILTER = "filter";
    private final IMessageBundle Msg = PACKAGE.Messages;
    private IFactory<IXMLSignatureContainerBuilder> xmlSignerFactory;

    public static IFactory<IXMLSignatureContainerBuilder> getContainerBuilderFactory(Object format) throws ObjectCreationException {
        if (format instanceof IFactory) {
            return (IFactory)format;
        }
        try {
            String formatId = (String)ConverterRegistry.get().convert(format, String.class);
            IFactory factory = FactoryTools.lookupFactoryFor(IXMLSignatureContainerBuilder.class, (List)ListTools.with((Object[])new Tag[]{new Tag(ARG_FORMAT, formatId)}));
            if (factory == null && (factory = FactoryTools.lookupFactory((String)formatId, null)) == null) {
                throw new ObjectCreationException("Invalid XML signature format: " + formatId);
            }
            return factory;
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public static IFactory<IXMLSignatureContainerBuilder> getFormat(IArgs args, Object defaultValue) throws ObjectCreationException {
        Object format = args.get(ARG_FORMAT);
        if (format == null) {
            format = defaultValue;
        }
        return AbstractXMLDocumentSigner.getContainerBuilderFactory(format);
    }

    public static boolean isEmbedDocument(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"embedDocument", (boolean)false);
    }

    public AbstractXMLDocumentSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected String getSignedDocManipulationMessage() {
        return this.Msg.getString("AbstractXMLDocumentSigner.ErrorDocInconsistency", new Object[0]);
    }

    public IFactory<IXMLSignatureContainerBuilder> getXmlSignerFactory() {
        return this.xmlSignerFactory;
    }

    public boolean isEmbedDocument() {
        return AbstractXMLDocumentSigner.isEmbedDocument(this.getArgs());
    }

    public void setXmlSignerFactory(IFactory<IXMLSignatureContainerBuilder> xmlSignerFactory) {
        this.xmlSignerFactory = xmlSignerFactory;
    }
}

