/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.xml.signature;

import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.xml.XMLDocument;
import de.intarsys.document.type.xml.XMLDocumentType;
import de.intarsys.security.document.type.xml.signature.AbstractXMLDocumentSigner;
import de.intarsys.security.method.xml.signature.BinaryDocumentTarget;
import de.intarsys.security.method.xml.signature.ISignatureTarget;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.processor.signature.AttachmentLocatorStrategy;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDocumentExternalSigner
extends AbstractXMLDocumentSigner {
    private XMLDocument destinationDocument;

    public XMLDocumentExternalSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        try {
            this.checkSignedDocumentConsistency();
            ILocator source = this.getDocument().getLocator();
            ILocator destination = this.createDestinationLocator(source);
            this.setDestinationDocument(this.createDestinationDocument(destination));
            IXMLSignatureContainerBuilder builder = this.createSignatureContainerBuilder(destination, digester);
            List<ISignatureTarget> targets = this.createSignatureTargets();
            for (ISignatureTarget target : targets) {
                builder.addSignatureTarget(target);
            }
            Document w3cDoc = this.getDestinationDocument().getW3CDocument();
            IConversation conversation = builder.sign(w3cDoc);
            return conversation.thenApply(container -> {
                this.getDestinationDocument().save();
                container.setLocator(destination);
                container.setDetached(true);
                return container;
            });
        }
        catch (DocumentSignerException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)new DocumentSignerException(e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected void basicStop() throws Exception {
        if (this.getDestinationDocument() != null) {
            this.getDestinationDocument().release(null);
        }
        super.basicStop();
    }

    protected XMLDocument createDestinationDocument(ILocator destination) throws IOException {
        IDocumentType documentType = DocumentOutlet.get().lookupDocumentType(XMLDocumentType.ID);
        if (destination.exists() && AttachmentLocatorStrategy.isAppend((IArgs)this.getArgs())) {
            this.destinationDocument = (XMLDocument)documentType.createFromLocator(destination, (IArgs)Args.create());
        } else {
            this.destinationDocument = (XMLDocument)documentType.createNew((IArgs)Args.create());
            Document doc = this.destinationDocument.getImpl();
            Element eRoot = doc.createElement("container");
            doc.appendChild(eRoot);
            this.destinationDocument.save((Object)destination);
        }
        return this.destinationDocument;
    }

    protected IXMLSignatureContainerBuilder createSignatureContainerBuilder(ILocator destination, IDigester digester) throws ObjectCreationException {
        IArgs signerArgs = this.getArgs().copy();
        signerArgs.put("signer", (Object)this.getDigestSigner());
        String baseUri = new File(destination.getPath()).toURI().toString();
        signerArgs.put("baseUri", (Object)baseUri);
        signerArgs.put("digester", (Object)digester);
        IXMLSignatureContainerBuilder signer = (IXMLSignatureContainerBuilder)this.getXmlSignerFactory().createInstance(signerArgs);
        return signer;
    }

    protected List<ISignatureTarget> createSignatureTargets() {
        ArrayList<ISignatureTarget> targets = new ArrayList<ISignatureTarget>();
        BinaryDocumentTarget target = new BinaryDocumentTarget(this.getDocument().getLocator());
        target.setEmbed(this.isEmbedDocument());
        target.setMimeType(this.getDocument().getType().getDefaultMimeType());
        targets.add((ISignatureTarget)target);
        return targets;
    }

    public XMLDocument getDestinationDocument() {
        return this.destinationDocument;
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        AttachmentLocatorStrategy strategy = AttachmentLocatorStrategy.create((IArgs)this.getArgs());
        strategy.setExtension(AttachmentLocatorStrategy.getLocatorExtension((IArgs)this.getArgs(), (String)this.getLocatorExtensionDefault()));
        return strategy;
    }

    protected String getLocatorExtensionDefault() {
        return "xml";
    }

    public void setDestinationDocument(XMLDocument destinationDocument) {
        this.destinationDocument = destinationDocument;
    }
}

