/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.xml.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.xml.XMLDocument;
import de.intarsys.security.document.type.xml.signature.AbstractXMLDocumentSigner;
import de.intarsys.security.method.xml.signature.EnvelopedSignatureTransformation;
import de.intarsys.security.method.xml.signature.ISignatureTarget;
import de.intarsys.security.method.xml.signature.ITransformation;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignatureTarget;
import de.intarsys.security.method.xml.signature.XMLSignerTools;
import de.intarsys.security.processor.signature.DocumentSignerException;
import de.intarsys.security.processor.signature.SameDocumentLocatorStrategy;
import de.intarsys.security.processor.signature.SignatureLocatorCreationStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XMLDocumentInternalSigner
extends AbstractXMLDocumentSigner {
    private static final Logger Log = LoggerFactory.getLogger(XMLDocumentInternalSigner.class);

    public XMLDocumentInternalSigner(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected IConversation<ISignatureContainer> basicSign(IDigester digester) {
        try {
            this.checkSignedDocumentConsistency();
            ILocator source = this.getDocument().getLocator();
            ILocator destination = this.createDestinationLocator(source);
            IXMLSignatureContainerBuilder builder = this.createSignatureContainerBuilder(destination, digester);
            List<ISignatureTarget> targets = this.createSignatureTargets();
            for (ISignatureTarget target : targets) {
                builder.addSignatureTarget(target);
            }
            Document w3cDoc = this.getDestinationDocument().getW3CDocument();
            IConversation conversation = builder.sign(w3cDoc);
            return conversation.thenApply(container -> {
                this.saveDocument(destination);
                container.setLocator(destination);
                return container;
            });
        }
        catch (DocumentSignerException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)new DocumentSignerException(e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private ISignatureTarget createDefaultTarget() {
        String uri = "#xpointer(/)";
        XMLSignatureTarget target = new XMLSignatureTarget(uri);
        target.addTransformation((ITransformation)new EnvelopedSignatureTransformation());
        return target;
    }

    protected IXMLSignatureContainerBuilder createSignatureContainerBuilder(ILocator destination, IDigester digester) throws ObjectCreationException {
        IArgs signerArgs = this.getArgs().copy();
        signerArgs.put("signer", (Object)this.getDigestSigner());
        String baseUri = new File(destination.getPath()).toURI().toString();
        signerArgs.put("baseUri", (Object)baseUri);
        signerArgs.put("digester", (Object)digester);
        IXMLSignatureContainerBuilder signer = (IXMLSignatureContainerBuilder)this.getXmlSignerFactory().createInstance(signerArgs);
        return signer;
    }

    private List<ISignatureTarget> createSignatureTargets() throws DocumentSignerException {
        ArrayList<ISignatureTarget> targets = new ArrayList<ISignatureTarget>();
        IArgs references = this.getReferences();
        if (references.size() == 0) {
            targets.add(this.createDefaultTarget());
        } else {
            for (int i = 0; i < references.size(); ++i) {
                ISignatureTarget target;
                IArgs reference = ArgTools.toArgs((Object)references.get(i));
                try {
                    target = XMLSignerTools.createSignatureTarget((IArgs)reference);
                }
                catch (ObjectCreationException e) {
                    throw new DocumentSignerException(e.getLocalizedMessage(), (Throwable)e);
                }
                targets.add(target);
            }
        }
        return targets;
    }

    public XMLDocument getDestinationDocument() {
        return (XMLDocument)this.getDocument();
    }

    protected SignatureLocatorCreationStrategy getLocatorCreationStrategy() {
        SameDocumentLocatorStrategy strategy = new SameDocumentLocatorStrategy();
        return strategy;
    }

    private IArgs getReferences() {
        IArgs value;
        InstanceSpec referencesSpec = InstanceSpec.get((IArgs)this.getArgs(), (String)"references", IArgs.class, null);
        if (referencesSpec != null && referencesSpec.getFactory() != null) {
            try {
                return (IArgs)referencesSpec.createInstance();
            }
            catch (ObjectCreationException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        if ((value = ArgTools.getArgs((IArgs)this.getArgs(), (String)"references", (IArgs)Args.create())).names().isEmpty()) {
            return value;
        }
        return Args.createIndexed((Object[])new Object[]{value});
    }
}

