/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.xml.signature;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.xml.XMLDocument;
import de.intarsys.document.type.xml.XMLDocumentType;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.security.document.type.xml.signature.AbstractXMLDocumentSigner;
import de.intarsys.security.document.type.xml.signature.PACKAGE;
import de.intarsys.security.document.type.xml.signature.XMLDocumentInternalSigner;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilderFactoryXAdES;
import de.intarsys.security.processor.signature.CommonDocumentSignerFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;

public class XMLDocumentInternalSignerFactory
extends CommonDocumentSignerFactory {
    public static final String ID = XMLDocumentInternalSignerFactory.class.getName();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected CommonProcessor basicCreateDocumentProcessor(IDocument doc, IArgs args) throws ObjectCreationException {
        this.checkSignatureFormat(args);
        if (!(doc instanceof XMLDocument)) {
            throw new ObjectCreationException("other document types than XML are not supported, use XMLDocumentExternalSignerFactory");
        }
        XMLDocumentInternalSigner documentSigner = new XMLDocumentInternalSigner((IFactory)this, doc);
        documentSigner.setXmlSignerFactory(AbstractXMLDocumentSigner.getFormat(args, XMLSignatureContainerBuilderFactoryXAdES.get()));
        return documentSigner;
    }

    public boolean supports(IDocumentType docType) {
        return docType instanceof XMLDocumentType;
    }

    public boolean supports(String format) {
        try {
            return AbstractXMLDocumentSigner.getContainerBuilderFactory(format) != null;
        }
        catch (ObjectCreationException e) {
            return false;
        }
    }
}

