/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.document.type.xml.validation;

import de.intarsys.security.document.type.xml.validation.PACKAGE;
import de.intarsys.security.method.xml.signature.XMLSignatureContainer;
import de.intarsys.security.processor.validation.standard.DefaultSignatureContainerExtender;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XMLSignatureContainerExtender
extends DefaultSignatureContainerExtender {
    private static final Logger Log = LoggerFactory.getLogger(XMLSignatureContainerExtender.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public XMLSignatureContainerExtender(IFactory factory, ISignatureContainer pSignatureContainer) {
        super(factory, pSignatureContainer);
    }

    protected void process() throws Exception {
        super.process();
        XMLSignatureContainer xmlSignatureContainer = (XMLSignatureContainer)this.getSignatureContainer();
        Document xmlDocument = (Document)xmlSignatureContainer.getImpl();
        ILocator locator = xmlSignatureContainer.getLocator();
        OutputStream out = locator.getOutputStream();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(xmlDocument), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new FunctorExecutionException((Throwable)e);
        }
        finally {
            StreamTools.close((Closeable)out);
        }
    }
}

