/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.core;

import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.AuditSession;
import de.intarsys.security.audit.v2.core.AuditV2Protocol;
import de.intarsys.security.audit.v2.core.IAuditProtocol;
import de.intarsys.security.audit.v2.core.IAuditSession;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyProvider;
import de.intarsys.security.audit.v2.core.IAuditSignatureProvider;
import de.intarsys.security.audit.v2.core.IAuditTickProvider;
import de.intarsys.security.audit.v2.core.PlainSessionKeyCodec;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Singleton
public class Audit
implements IElementConfigurable,
IElementSerializable {
    private static IAuditSession ACTIVE;
    private int heartbeatInterval = -1;
    private int signInterval = -1;
    private ScheduledExecutorService executor;
    private String hashAlgorithmName = "SHA-256";
    private String hmacAlgorithmName = "HmacSHA1";
    private IAuditTickProvider tickProvider = new MillisTickProvider();
    private IAuditSessionKeyProvider sessionKeyProvider = new RandomSessionKeyProvider();
    private IAuditSignatureProvider signatureProvider = null;
    private final IAuditProtocol protocol;
    private IAuditSessionKeyCodec sessionKeyCodec = new PlainSessionKeyCodec();

    public static Audit createNew() {
        return new Audit();
    }

    public static Audit createNew(IAuditProtocol protocol) {
        return new Audit(protocol);
    }

    public static synchronized IAuditSession get() {
        return ACTIVE;
    }

    public static synchronized void set(IAuditSession active) {
        ACTIVE = active;
    }

    public Audit() {
        this(new AuditV2Protocol());
    }

    public Audit(IAuditProtocol protocol) {
        this.protocol = protocol;
        this.executor = new ScheduledThreadPoolExecutor(1, ThreadTools.newThreadFactoryDaemon((String)"audit heartbeat"));
    }

    public void configure(IElement element) throws ConfigurationException {
        String defaultHashAlgorithmName = element.attributeValue("digestAlgorithm", this.getHashAlgorithmName());
        this.setHashAlgorithmName(element.attributeValue("hashAlgorithm", defaultHashAlgorithmName));
        this.setHmacAlgorithmName(element.attributeValue("hmacAlgorithm", this.getHmacAlgorithmName()));
    }

    public IAuditSession createSession() throws AuditException {
        return new AuditSession(this, this.getSessionKeyProvider().getSessionKey(), null, 0);
    }

    public IAuditSession createSession(byte[] sessionKey, IDigest previousDigest, int sequenceNumber) throws AuditException {
        return new AuditSession(this, sessionKey, previousDigest, sequenceNumber);
    }

    protected Mac createSessionMac(byte[] key) throws GeneralSecurityException {
        Mac mac = Mac.getInstance(this.getHmacAlgorithmName());
        SecretKeySpec secret = new SecretKeySpec(key, this.getHmacAlgorithmName());
        mac.init(secret);
        return mac;
    }

    protected IDigester createSessionMessageDigest() throws NoSuchAlgorithmException {
        return DigestTools.createDigester((String)this.getHashAlgorithmName());
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public String getHmacAlgorithmName() {
        return this.hmacAlgorithmName;
    }

    public IAuditProtocol getProtocol() {
        return this.protocol;
    }

    public IAuditSessionKeyCodec getSessionKeyCodec() {
        return this.sessionKeyCodec;
    }

    public IAuditSessionKeyProvider getSessionKeyProvider() {
        return this.sessionKeyProvider;
    }

    public IAuditSignatureProvider getSignatureProvider() {
        return this.signatureProvider;
    }

    public int getSignInterval() {
        return this.signInterval;
    }

    public IAuditTickProvider getTickProvider() {
        return this.tickProvider;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("hashAlgorithm", this.getHashAlgorithmName());
        element.setAttributeValue("hmacAlgorithm", this.getHmacAlgorithmName());
    }

    public void setHashAlgorithmName(String hashAlgorithmName) {
        this.hashAlgorithmName = hashAlgorithmName;
    }

    public void setHeartbeatInterval(int heartbeatDelay) {
        this.heartbeatInterval = heartbeatDelay;
    }

    public void setHmacAlgorithmName(String value) {
        this.hmacAlgorithmName = value;
    }

    public void setSessionKeyCodec(IAuditSessionKeyCodec sessionKeyEncoder) {
        this.sessionKeyCodec = sessionKeyEncoder;
    }

    public void setSessionKeyProvider(IAuditSessionKeyProvider provider) {
        this.sessionKeyProvider = provider;
    }

    public void setSignatureProvider(IAuditSignatureProvider provider) {
        this.signatureProvider = provider;
    }

    public void setSignInterval(int signInterval) {
        this.signInterval = signInterval;
    }

    public void setTickProvider(IAuditTickProvider tickProvider) {
        this.tickProvider = tickProvider;
    }

    public static class MillisTickProvider
    implements IAuditTickProvider {
        @Override
        public long getTick() {
            return System.currentTimeMillis();
        }
    }

    public static class RandomSessionKeyProvider
    implements IAuditSessionKeyProvider {
        @Override
        public byte[] getSessionKey() {
            return ByteArrayTools.createRandomBytes((int)32);
        }
    }
}

