/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.core;

import de.intarsys.security.audit.v2.core.Audit;
import de.intarsys.security.audit.v2.core.AuditEntry;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditEntry;
import de.intarsys.security.audit.v2.core.IAuditSession;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.crypto.Mac;

public class AuditSession
implements IAuditSession {
    private final Runnable heartbeatRunner = new Runnable(){

        @Override
        public void run() {
            try {
                AuditSession.this.heartbeat();
            }
            catch (AuditException auditException) {
                // empty catch block
            }
        }
    };
    private final Runnable signRunner = new Runnable(){

        @Override
        public void run() {
            try {
                AuditSession.this.sign();
            }
            catch (AuditException auditException) {
                // empty catch block
            }
        }
    };
    private final Object lock = new Object();
    private final Audit audit;
    private final byte[] sessionKey;
    private int sequenceNumber;
    private final Mac mac;
    private final IDigester digester;
    private IDigest previousDigest;
    private final List<Consumer<IAuditEntry>> consumers = new CopyOnWriteArrayList<Consumer<IAuditEntry>>();
    private Future<?> heartbeatFuture;
    private Future<?> signFuture;
    private boolean closed = false;

    protected AuditSession(Audit audit, byte[] sessionKey, IDigest previousDigest, int sequenceNumber) throws AuditException {
        this.audit = audit;
        this.sessionKey = sessionKey;
        try {
            this.mac = audit.createSessionMac(sessionKey);
            this.digester = audit.createSessionMessageDigest();
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        this.previousDigest = previousDigest;
        this.sequenceNumber = sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuditEntry close() throws AuditException {
        Object object = this.lock;
        synchronized (object) {
            if (this.heartbeatFuture != null) {
                this.heartbeatFuture.cancel(false);
                this.heartbeatFuture = null;
            }
            if (this.signFuture != null) {
                this.signFuture.cancel(false);
                this.signFuture = null;
            }
            this.closed = true;
            AuditEntry entry = new AuditEntry();
            this.getAudit().getProtocol().handleEntryClose(this, entry);
            this.trigger(entry);
            return entry;
        }
    }

    public Audit getAudit() {
        return this.audit;
    }

    protected IDigester getDigester() {
        return this.digester;
    }

    protected Mac getMac() {
        return this.mac;
    }

    protected IDigest getPreviousDigest() {
        return this.previousDigest;
    }

    protected int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getSessionKey() {
        return (byte[])this.sessionKey.clone();
    }

    public Map getSessionKeyParams() throws AuditException {
        IAuditSessionKeyCodec codec = this.getAudit().getSessionKeyCodec();
        return codec.createSessionKeyParams(this.sessionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuditEntry heartbeat() throws AuditException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            AuditEntry entry = new AuditEntry();
            this.getAudit().getProtocol().handleEntryHeartbeat(this, entry);
            this.trigger(entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuditEntry log(String message) throws AuditException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            AuditEntry entry = new AuditEntry();
            entry.setAuditMessage(message);
            this.getAudit().getProtocol().handleEntryLog(this, entry);
            this.trigger(entry);
            return entry;
        }
    }

    @Override
    public void onEntry(Consumer<IAuditEntry> consumer) {
        this.consumers.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuditEntry open() throws AuditException {
        Object object = this.lock;
        synchronized (object) {
            AuditEntry entry = new AuditEntry();
            this.getAudit().getProtocol().handleEntryOpen(this, entry);
            this.trigger(entry);
            if (this.getAudit().getHeartbeatInterval() > 0) {
                this.heartbeatFuture = this.getAudit().getExecutor().scheduleAtFixedRate(this.heartbeatRunner, this.getAudit().getHeartbeatInterval(), this.getAudit().getHeartbeatInterval(), TimeUnit.MINUTES);
            }
            if (this.getAudit().getSignInterval() > 0) {
                this.signFuture = this.getAudit().getExecutor().scheduleAtFixedRate(this.signRunner, this.getAudit().getSignInterval(), this.getAudit().getSignInterval(), TimeUnit.MINUTES);
            }
            this.closed = false;
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuditEntry sign() throws AuditException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            if (this.getAudit().getSignatureProvider() == null) {
                return null;
            }
            AuditEntry entry = new AuditEntry();
            this.getAudit().getProtocol().handleEntrySign(this, entry);
            this.trigger(entry);
            return entry;
        }
    }

    protected void trigger(AuditEntry entry) {
        for (Consumer<IAuditEntry> consumer : this.consumers) {
            consumer.accept(entry);
        }
    }

    protected void updateState(int newSequenceNumber, IDigest newDigest) {
        this.sequenceNumber = newSequenceNumber;
        this.previousDigest = newDigest;
    }
}

