/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeShortType;

public class NativeShort
extends NativeNumber {
    public static final NativeShortType META = new NativeShortType();

    public static NativeShort createFromAddress(long address) {
        return (NativeShort)META.createNative(NativeTools.toHandle(address));
    }

    public NativeShort() {
        this.allocate();
    }

    protected NativeShort(INativeHandle handle) {
        super(handle);
    }

    public NativeShort(short value) {
        this.allocate();
        this.setValue(value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.shortValue();
    }

    @Override
    public float floatValue() {
        return this.shortValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return this.shortValue();
    }

    @Override
    public int intValue() {
        return this.shortValue();
    }

    @Override
    public long longValue() {
        return this.shortValue();
    }

    @Override
    public void setValue(Object value) {
        this.setValue(((Number)value).shortValue());
    }

    public void setValue(short value) {
        this.handle.setShort(0, value);
    }

    @Override
    public short shortValue() {
        return this.handle.getShort(0);
    }

    public String toString() {
        if (this.getNativeHandle() == null) {
            return "nope - no handle";
        }
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.shortValue());
    }
}

