/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.jpa.common;

import de.intarsys.jpa.common.IdObject;
import de.intarsys.jpa.common.JPAModelTools;
import de.intarsys.jpa.common.TrackedPersistentObject;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Query;
import jakarta.persistence.Transient;
import java.util.List;

@MappedSuperclass
public abstract class AttachedPersistentObject<T extends IdObject>
extends TrackedPersistentObject {
    @Transient
    private T entity;
    @Column(name="c_entity_id")
    private int entityId;
    @Column(name="c_entity_type")
    private String entityType;

    public static <T extends AttachedPersistentObject> List<T> selectByOwner(EntityManager em, Class<T> clazz, IdObject owner) {
        Query query = em.createQuery("SELECT x FROM " + JPAModelTools.getEntityAlias(clazz) + " x where x.entityId = :entityId AND x.entityType = :entityType");
        String entityType = JPAModelTools.getEntityAlias(owner.getClass());
        int entityId = owner.getId();
        query.setParameter("entityType", (Object)entityType);
        query.setParameter("entityId", (Object)entityId);
        List objects = query.getResultList();
        return objects;
    }

    @Override
    public void checkUndeclaredAssociations() {
        if (this.entity != null && this.entityId != ((IdObject)this.entity).getId()) {
            this.entityId = ((IdObject)this.entity).getId();
        }
    }

    protected T deriveEntity(EntityManager em) {
        if (this.getEntityType() == null) {
            return null;
        }
        return (T)IdObject.selectById(em, this.getEntityType(), this.getEntityId());
    }

    public T getEntity(EntityManager em) {
        if (this.entity == null) {
            this.entity = this.deriveEntity(em);
        }
        return this.entity;
    }

    public int getEntityId() {
        if (this.entity != null) {
            return ((IdObject)this.entity).getId();
        }
        return this.entityId;
    }

    public String getEntityType() {
        if (this.entity != null) {
            return JPAModelTools.getEntityAlias(this.entity.getClass());
        }
        return this.entityType;
    }

    @Override
    public boolean hasUndeclaredAssociations() {
        return true;
    }

    @Override
    public void hookBeforeInsert() {
        if (this.entity == null) {
            this.entityType = null;
            this.entityId = -1;
        } else {
            this.entityType = JPAModelTools.getEntityAlias(this.entity.getClass());
            this.entityId = ((IdObject)this.entity).getId();
        }
        super.hookBeforeInsert();
    }

    public void setEntity(T pEntity) {
        if (!this.willChange("entity", null, null)) {
            return;
        }
        if (this.entity == pEntity) {
            return;
        }
        this.entity = pEntity;
    }

    public void setEntityId(int entityId) {
        if (!this.willChange("entityId", null, null)) {
            return;
        }
        this.entityId = entityId;
        this.entity = null;
    }

    public void setEntityType(String entityType) {
        if (!this.willChange("entityType", null, null)) {
            return;
        }
        this.entityType = entityType;
        this.entity = null;
    }
}

