/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.jpa.common;

import de.intarsys.jpa.common.AfterInsertEvent;
import de.intarsys.jpa.common.AfterLoadEvent;
import de.intarsys.jpa.common.AfterRemoveEvent;
import de.intarsys.jpa.common.AfterUpdateEvent;
import de.intarsys.jpa.common.BeforeInsertEvent;
import de.intarsys.jpa.common.BeforeRemoveEvent;
import de.intarsys.jpa.common.BeforeUpdateEvent;
import de.intarsys.jpa.common.IPersistentObject;
import de.intarsys.jpa.common.JPAModelTools;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import jakarta.persistence.EntityManager;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
public abstract class BasicPersistentObject
implements IPersistentObject,
Serializable,
IPresentationSupport,
INotificationSupport {
    private static final Logger Log = LoggerFactory.getLogger(BasicPersistentObject.class);
    protected static final Map<String, Object> EMPTY_PARAMETERS = Collections.emptyMap();
    private transient boolean persistent = false;
    private transient boolean dirty = true;
    private transient EventDispatcher dispatcher = new EventDispatcher((Object)this);

    public static <T> List<T> all(EntityManager em, Class<T> clazz) {
        return BasicPersistentObject.query(em, clazz, EMPTY_PARAMETERS);
    }

    public static int count(EntityManager em, Class clazz) {
        return BasicPersistentObject.count(em, clazz, EMPTY_PARAMETERS);
    }

    public static int count(EntityManager em, Class clazz, Map<String, Object> parameters) {
        String queryString = BasicPersistentObject.createDefaultCount(clazz, parameters);
        return BasicPersistentObject.count(em, clazz, queryString, parameters);
    }

    public static int count(EntityManager em, Class clazz, String queryString, Map<String, Object> parameters) {
        return ((Number)BasicPersistentObject.querySingle(em, clazz, queryString, parameters)).intValue();
    }

    protected static String createDefaultCount(Class clazz, Map<String, Object> parameters) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("SELECT count(x) FROM ");
        queryString.append(JPAModelTools.getEntityAlias(clazz));
        queryString.append(" x");
        ArrayList<String> remove = new ArrayList<String>();
        if (!parameters.isEmpty()) {
            queryString.append(" WHERE");
            Iterator<String> i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String paramName = i.next();
                queryString.append(" x.");
                queryString.append(paramName);
                if (parameters.get(paramName) == null) {
                    queryString.append(" IS NULL");
                    remove.add(paramName);
                } else {
                    queryString.append(" = :");
                    queryString.append(paramName);
                }
                if (!i.hasNext()) continue;
                queryString.append(" AND");
            }
        }
        for (String paramName : remove) {
            parameters.remove(paramName);
        }
        return queryString.toString();
    }

    protected static String createDefaultQuery(Class clazz, Map<String, Object> parameters) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("SELECT x FROM ");
        queryString.append(JPAModelTools.getEntityAlias(clazz));
        queryString.append(" x");
        ArrayList<String> remove = new ArrayList<String>();
        if (!parameters.isEmpty()) {
            queryString.append(" WHERE");
            Iterator<String> i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String paramName = i.next();
                queryString.append(" x.");
                queryString.append(paramName);
                if (parameters.get(paramName) == null) {
                    queryString.append(" IS NULL");
                    remove.add(paramName);
                } else {
                    queryString.append(" = :");
                    queryString.append(paramName);
                }
                if (!i.hasNext()) continue;
                queryString.append(" AND");
            }
        }
        for (String paramName : remove) {
            parameters.remove(paramName);
        }
        return queryString.toString();
    }

    public static <T> T lookup(EntityManager em, Class<T> clazz, Object id) {
        return (T)em.find(clazz, id);
    }

    public static <T> List<T> query(Class<T> clazz, Query query, Map<String, Object> parameters) {
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            query.setParameter(parameter.getKey(), parameter.getValue());
        }
        List objects = query.getResultList();
        return objects;
    }

    public static <T> List<T> query(EntityManager em, Class<T> clazz, Map<String, Object> parameters) {
        parameters = new HashMap<String, Object>(parameters);
        String queryString = BasicPersistentObject.createDefaultQuery(clazz, parameters);
        return BasicPersistentObject.query(em, clazz, queryString, parameters);
    }

    public static <T> List<T> query(EntityManager em, Class<T> clazz, String queryString, Map<String, Object> parameters) {
        Query query = em.createQuery(queryString);
        return BasicPersistentObject.query(clazz, query, parameters);
    }

    public static <T> T querySingle(EntityManager em, Class<T> clazz, Map<String, Object> parameters) {
        List<T> result = BasicPersistentObject.query(em, clazz, parameters);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public static <T> T querySingle(EntityManager em, Class<T> clazz, String query, Map<String, Object> parameters) {
        List<T> result = BasicPersistentObject.query(em, clazz, query, parameters);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected BasicPersistentObject() {
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected String basicGetLabel() {
        return this.toString();
    }

    @Override
    public void checkUndeclaredAssociations() {
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return String.valueOf(this.getPrimaryKey());
    }

    @Override
    public abstract Object getPrimaryKey();

    public String getTip() {
        return this.getLabel();
    }

    @Override
    public boolean hasUndeclaredAssociations() {
        return false;
    }

    @PostPersist
    public void hookAfterInsert() {
        Log.debug("inserted " + this.getClass().getName() + ":" + this.basicGetLabel());
        this.persistent = true;
        this.dirty = false;
        this.triggerEvent(new AfterInsertEvent(this));
    }

    @PostLoad
    public void hookAfterLoad() {
        Log.debug("loaded " + this.getClass().getName() + ":" + this.basicGetLabel());
        if (this.isLoaded()) {
            this.persistent = true;
            this.dirty = false;
        }
        this.triggerEvent(new AfterLoadEvent(this));
    }

    @PostRemove
    public void hookAfterRemove() {
        Log.debug("removed " + this.getClass().getName() + ":" + this.basicGetLabel());
        this.persistent = false;
        this.dirty = false;
        this.triggerEvent(new AfterRemoveEvent(this));
    }

    @PostUpdate
    public void hookAfterUpdate() {
        Log.debug("updated " + this.getClass().getName() + ":" + this.basicGetLabel());
        this.persistent = true;
        this.dirty = false;
        this.triggerEvent(new AfterUpdateEvent(this));
    }

    @PrePersist
    public void hookBeforeInsert() {
        if (this.isLoaded()) {
            throw new IllegalStateException("re-insert persistent object");
        }
        this.triggerEvent(new BeforeInsertEvent(this));
    }

    @PreRemove
    public void hookBeforeRemove() {
        this.triggerEvent(new BeforeRemoveEvent(this));
    }

    @PreUpdate
    public void hookBeforeUpdate() {
        this.triggerEvent(new BeforeUpdateEvent(this));
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected boolean isLoaded() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void resetDirty() {
        this.dirty = false;
    }

    public void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    protected void updateCopy(BasicPersistentObject copy) {
        copy.dirty = this.dirty;
        copy.persistent = this.persistent;
    }

    protected boolean willChange(String attribute, Object oldValue, Object newValue) {
        this.markDirty();
        return true;
    }
}

