/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.jpa.common;

import de.intarsys.jpa.common.BasicPersistentObject;
import de.intarsys.jpa.common.JPAModelTools;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Query;
import java.io.ObjectStreamException;
import java.util.List;

@MappedSuperclass
public class IdObject
extends BasicPersistentObject {
    @Id
    @Column(name="c_id")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;

    public static <T extends IdObject> T selectById(EntityManager manager, Class<T> clazz, int id) {
        return (T)IdObject.selectById(manager, JPAModelTools.getEntityAlias(clazz), id);
    }

    public static IdObject selectById(EntityManager manager, String alias, int id) {
        String queryString = "SELECT x from " + alias + " x where x.id = :id";
        Query query = manager.createQuery(queryString);
        query.setParameter("id", (Object)id);
        List objects = query.getResultList();
        if (objects.size() > 0) {
            return (IdObject)objects.get(0);
        }
        return null;
    }

    public IdObject copy() {
        IdObject tempObject = this.createEmptyObject();
        return tempObject;
    }

    protected IdObject createEmptyObject() {
        throw new UnsupportedOperationException();
    }

    public Integer getId() {
        return this.id;
    }

    protected String getInstanceLabel() {
        return this.getClass().getName() + ":" + this.getId();
    }

    @Override
    public Object getPrimaryKey() {
        return this.getId() < 0 ? null : this.getId();
    }

    @Override
    protected boolean isLoaded() {
        return this.id != null;
    }

    protected void resetHousekeeping() throws ObjectStreamException {
        this.id = null;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    protected void updateCopy(BasicPersistentObject copy) {
        super.updateCopy(copy);
        ((IdObject)copy).id = this.id;
    }
}

