/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.jpa.common;

import de.intarsys.jpa.common.IdObject;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Version;
import java.io.ObjectStreamException;
import java.sql.Timestamp;
import java.util.Date;

@MappedSuperclass
public class TrackedPersistentObject
extends IdObject {
    @Column(name="c_created")
    private Timestamp created;
    @Column(name="c_changed")
    private Timestamp changed;
    @Version
    @Column(name="c_update")
    private int update;

    public Timestamp getChanged() {
        return this.changed;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public int getUpdate() {
        return this.update;
    }

    @Override
    public void hookBeforeInsert() {
        super.hookBeforeInsert();
        Timestamp now = new Timestamp(new Date().getTime());
        if (this.created == null) {
            this.setCreated(now);
        }
        if (this.changed == null) {
            this.setChanged(now);
        }
    }

    @Override
    public void hookBeforeUpdate() {
        super.hookBeforeUpdate();
        Timestamp now = new Timestamp(new Date().getTime());
        this.setChanged(now);
    }

    @Override
    protected void resetHousekeeping() throws ObjectStreamException {
        this.created = null;
        this.changed = null;
        this.update = 0;
        super.resetHousekeeping();
    }

    public void setChanged(Timestamp changed) {
        this.changed = changed;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
    }

    protected void setUpdate(int update) {
        this.update = update;
    }
}

