/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.liquibase;

import de.intarsys.tools.string.StringTools;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseTools {
    protected static Database createDatabaseObject(Connection connection) throws LiquibaseException {
        try {
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            Database database = databaseFactory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            return database;
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException((Throwable)e);
        }
    }

    protected static Database createDatabaseObject(DataSource dataSource) throws LiquibaseException {
        try {
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            Database database = databaseFactory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(dataSource.getConnection()));
            return database;
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException((Throwable)e);
        }
    }

    protected static Database createDatabaseObject(String url, String user, String password, String schema) throws LiquibaseException {
        try {
            Properties info = new Properties();
            if (user != null) {
                info.put("user", user);
            }
            if (password != null) {
                info.put("password", password);
            }
            Connection connection = DriverManager.getConnection(url, info);
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            Database database = databaseFactory.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            database.setDefaultSchemaName(StringTools.trimToNull((String)schema));
            return database;
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SetupException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDatabase(DataSource dataSource, String changeLog, String contexts) throws LiquibaseException, SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Database database = LiquibaseTools.createDatabaseObject(connection);
            LiquibaseTools.updateDatabase(database, changeLog, contexts);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDatabase(EntityManagerFactory emf, String changeLog, String contexts) throws LiquibaseException {
        EntityManager em = null;
        try {
            em = emf.createEntityManager();
            em.getTransaction().begin();
            Connection connection = (Connection)em.unwrap(Connection.class);
            Database database = LiquibaseTools.createDatabaseObject(connection);
            LiquibaseTools.updateDatabase(database, changeLog, contexts);
        }
        finally {
            if (em != null) {
                em.getTransaction().commit();
            }
        }
    }

    public static void updateDatabase(Database database, String changeLog, String contexts) throws LiquibaseException {
        ArrayList<ClassLoaderResourceAccessor> accessors = new ArrayList<ClassLoaderResourceAccessor>();
        ClassLoader me_classLoader = LiquibaseTools.class.getClassLoader();
        ClassLoaderResourceAccessor this_accessor = new ClassLoaderResourceAccessor(me_classLoader);
        ClassLoaderResourceAccessor database_accessor = new ClassLoaderResourceAccessor();
        accessors.add(this_accessor);
        accessors.add(database_accessor);
        CompositeResourceAccessor accessor = new CompositeResourceAccessor(accessors);
        Liquibase liquibase = new Liquibase(changeLog, (ResourceAccessor)accessor, database);
        liquibase.update(contexts);
    }

    public static void updateDatabase(String persistenceUnit, String changeLog, String contexts) throws LiquibaseException {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnit, new HashMap());
        LiquibaseTools.updateDatabase(emf, changeLog, contexts);
    }

    public static void updateDatabase(String url, String user, String password, String changeLog, String contexts) throws LiquibaseException {
        Database database = LiquibaseTools.createDatabaseObject(url, user, password, null);
        LiquibaseTools.updateDatabase(database, changeLog, contexts);
    }
}

