/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.pin;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.security.auth.module.pin.PACKAGE;
import de.intarsys.security.auth.module.pin.PinAuthenticationModule;
import de.intarsys.security.auth.module.pin.PinCredential;
import de.intarsys.security.auth.module.pin.PinCredentialSpec;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinAuthenticationContext
extends CommonAuthenticationContext {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(PinAuthenticationContext.class);

    public PinAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        super(authenticationModule, subject);
    }

    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        IConversation conversation = this.createConversation(authenticationArgs);
        try {
            CommonAuthenticationState state = this.createState(conversation, authenticationArgs);
            PinCredentialSpec pinSpec = (PinCredentialSpec)this.getAuthenticationModule().getCredentialSpec();
            if (pinSpec.isPrivateUi()) {
                UriBuilder uriBuilder = RequestContext.get().getUriBuilderContext();
                uriBuilder.path(this.getAuthenticationModule().getUiPath());
                uriBuilder.path("pin.html");
                uriBuilder.queryParam("state", new Object[]{conversation.getHandle()});
                String redirectUri = uriBuilder.toString();
                Log.info("{} redirect to {}", (Object)conversation.getHandle(), (Object)redirectUri);
                boolean oob = pinSpec.isOutOfBand();
                HttpRedirectStage replyStage = new HttpRedirectStage(redirectUri, oob, !oob);
                if (oob) {
                    ConversationServiceTools.setOobActive((IConversation)conversation, (boolean)oob);
                    replyStage.onAck(ack -> {
                        ProcessingStage nextStage = new ProcessingStage();
                        conversation.setReplyStage((IReplyStage)nextStage);
                    });
                }
                conversation.setReplyStage((IReplyStage)replyStage);
                ConversationRegistry.publishForLifetime((IConversation)conversation);
            } else {
                RequestInputStage replyStage = new RequestInputStage();
                replyStage.setType("pin");
                replyStage.setTitle("Enter PIN");
                replyStage.setMessage(pinSpec.getLabel());
                replyStage.onAck(ack -> this.verify(state, ack));
                conversation.setReplyStage((IReplyStage)replyStage);
            }
        }
        catch (Exception e) {
            conversation.completeExceptionally((Throwable)e);
        }
        return conversation;
    }

    protected ICredential convertToCredential(Object ack) throws AuthenticationException {
        if (ack instanceof String) {
            String value = (String)ack;
            if (StringTools.isEmpty((String)value)) {
                throw new AuthenticationCanceled();
            }
            return PinCredential.create(this.getAuthenticationModule().getCredentialSpec(), value);
        }
        return super.convertToCredential(ack);
    }

    public PinAuthenticationModule getAuthenticationModule() {
        return (PinAuthenticationModule)super.getAuthenticationModule();
    }
}

