/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.pin;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.ICredentialSpec;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.ICredentialVerifier;
import de.intarsys.security.auth.module.pin.PinAuthenticationContext;
import de.intarsys.security.auth.module.pin.PinCredentialSpec;
import de.intarsys.security.auth.module.pin.StaticPinCredentialVerifier;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import javax.security.auth.Subject;

public class PinAuthenticationModule
extends CommonAuthenticationModule {
    private String uiPath = "auth";

    public IAuthenticationContext createContext(Subject subject) {
        return new PinAuthenticationContext(this, subject);
    }

    public String getUiPath() {
        return this.uiPath;
    }

    @PostConstruct
    public void init() {
        super.init();
        String label = ArgTools.getString((IArgs)this.getArgs(), (String)"label", (String)this.getId());
        String purpose = ArgTools.getString((IArgs)this.getArgs(), (String)"purpose", null);
        boolean privateUi = ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"privateUi", (boolean)false);
        boolean oob = ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"oob", (boolean)false);
        PinCredentialSpec spec = new PinCredentialSpec(label, oob, privateUi);
        spec.setPurpose(purpose);
        this.setCredentialSpec((ICredentialSpec)spec);
        Secret value = ArgTools.getSecretHide((IArgs)this.getArgs(), (String)"pin", null);
        if (CryptoTools.isEmpty((Secret)value)) {
            value = ArgTools.getSecretParse((IArgs)this.getArgs(), (String)"value", null);
        }
        if (!CryptoTools.isEmpty((Secret)value)) {
            this.setCredentialVerifier((ICredentialVerifier)new StaticPinCredentialVerifier(spec, value));
        }
    }

    public void setUiPath(String uiPath) {
        this.uiPath = uiPath;
    }
}

