/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.pin;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredentialSpec;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.aaa.authenticate.impl.CommonCredentialVerifier;
import de.intarsys.security.auth.module.pin.PinCredential;
import de.intarsys.security.auth.module.pin.PinCredentialSpec;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;
import java.security.GeneralSecurityException;

public class StaticPinCredentialVerifier
extends CommonCredentialVerifier<PinCredentialSpec, PinCredential> {
    private Secret value;

    public StaticPinCredentialVerifier(PinCredentialSpec spec, Secret value) {
        super((ICredentialSpec)spec);
        this.value = value;
    }

    protected void basicVerify(CommonAuthenticationState state, PinCredential credential) throws AuthenticationException {
        try {
            if (StringTools.isEmpty((String)credential.getValue())) {
                throw new AuthenticationCanceled("canceled");
            }
            if (!LangTools.equals((Object)credential.getValue(), (Object)this.value.getString())) {
                throw new AuthenticationFailed("invalid credential");
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationFailed((Throwable)e);
        }
    }
}

