/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.smartcard;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.security.auth.module.smartcard.PACKAGE;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationModule;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationState;
import de.intarsys.security.auth.module.smartcard.SmartcardCredential;
import de.intarsys.security.auth.module.smartcard.SmartcardCredentialSpec;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardAuthenticationContext
extends CommonAuthenticationContext {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(SmartcardAuthenticationContext.class);

    public SmartcardAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        super(authenticationModule, subject);
    }

    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        IConversation conversation = this.createConversation(authenticationArgs);
        try {
            CommonAuthenticationState state = this.createState(conversation, authenticationArgs);
            SmartcardCredentialSpec smartcardSpec = (SmartcardCredentialSpec)this.getAuthenticationModule().getCredentialSpec();
            if (smartcardSpec.isPrivateUi()) {
                UriBuilder uriBuilder = RequestContext.get().getUriBuilderContext();
                uriBuilder.path(this.getAuthenticationModule().getUiPath());
                uriBuilder.path("smartcard.html.jsp");
                uriBuilder.queryParam("state", new Object[]{conversation.getHandle()});
                HttpRedirectStage replyStage = new HttpRedirectStage(uriBuilder.toString(), false, true);
                conversation.setReplyStage((IReplyStage)replyStage);
                ConversationRegistry.publishForLifetime((IConversation)conversation);
            } else {
                RequestInputStage replyStage = new RequestInputStage();
                replyStage.setType("smartcard");
                replyStage.onAck(ack -> this.verify(state, ack));
                conversation.setReplyStage((IReplyStage)replyStage);
            }
        }
        catch (Exception e) {
            conversation.completeExceptionally((Throwable)e);
        }
        return conversation;
    }

    protected CommonAuthenticationState basicCreateState(IConversation conversation, IArgs authenticationArgs) throws Exception {
        return new SmartcardAuthenticationState(this, conversation, authenticationArgs);
    }

    protected ICredential convertToCredential(Object ack) throws AuthenticationException {
        if (ack instanceof String) {
            String value = (String)ack;
            if (StringTools.isEmpty((String)value)) {
                throw new AuthenticationCanceled();
            }
            String[] parts = value.split(",");
            try {
                byte[] response = Base64.decode((String)parts[0]);
                byte[] certificate = Base64.decode((String)parts[1]);
                SmartcardCredential credential = SmartcardCredential.create(this.getAuthenticationModule().getCredentialSpec(), response, certificate);
                return credential;
            }
            catch (IOException e) {
                throw new AuthenticationFailed((Throwable)e);
            }
        }
        return super.convertToCredential(ack);
    }

    public SmartcardAuthenticationModule getAuthenticationModule() {
        return (SmartcardAuthenticationModule)super.getAuthenticationModule();
    }
}

