/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.smartcard;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationEvidence;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationState;
import de.intarsys.security.auth.module.smartcard.SmartcardCredential;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SmartcardAuthenticationEvidence
extends CommonAuthenticationEvidence {
    private final SmartcardCredential credential;

    public SmartcardAuthenticationEvidence(CommonAuthenticationState authenticationState, SmartcardCredential credential) {
        super(authenticationState);
        this.credential = credential;
    }

    public byte[] getCertificate() {
        return this.getCredential().getCertificate();
    }

    public byte[] getChallenge() {
        return ((SmartcardAuthenticationState)this.getAuthenticationState()).getChallenge();
    }

    protected SmartcardCredential getCredential() {
        return this.credential;
    }

    public byte[] getResponse() {
        return this.getCredential().getResponse();
    }

    public Map<String, Object> toMap() throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", "ChallengeResponse");
        result.put("created", this.getCreated());
        result.put("challenge", new String(Base64.encode((byte[])this.getChallenge())));
        result.put("response", new String(Base64.encode((byte[])this.getResponse())));
        result.put("certificate", new String(Base64.encode((byte[])this.getCertificate())));
        return result;
    }
}

