/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.smartcard;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.ICredentialSpec;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.ICredentialVerifier;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationContext;
import de.intarsys.security.auth.module.smartcard.SmartcardCredentialSpec;
import de.intarsys.security.auth.module.smartcard.SmartcardCredentialVerifier;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import javax.security.auth.Subject;

public class SmartcardAuthenticationModule
extends CommonAuthenticationModule {
    private String uiPath = "auth";

    public IAuthenticationContext createContext(Subject subject) {
        return new SmartcardAuthenticationContext(this, subject);
    }

    public String getUiPath() {
        return this.uiPath;
    }

    @PostConstruct
    public void init() {
        super.init();
        String label = ArgTools.getString((IArgs)this.getArgs(), (String)"label", (String)this.getId());
        String purpose = ArgTools.getString((IArgs)this.getArgs(), (String)"purpose", null);
        boolean privateUi = ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)"privateUi", (boolean)true);
        SmartcardCredentialSpec specSmartcard = new SmartcardCredentialSpec(label, privateUi);
        specSmartcard.setPurpose(purpose);
        this.setCredentialSpec((ICredentialSpec)specSmartcard);
        this.setCredentialVerifier((ICredentialVerifier)new SmartcardCredentialVerifier(specSmartcard));
    }

    public void setUiPath(String uiPath) {
        this.uiPath = uiPath;
    }
}

