/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.smartcard;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProvider;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SmartcardAuthenticationState
extends CommonAuthenticationState {
    private byte[] challenge;
    private IX509PublicKeyCertificate certificate;

    public SmartcardAuthenticationState(CommonAuthenticationContext context, IConversation conversation, IArgs args) throws ObjectCreationException {
        super(context, conversation, args);
        this.init();
    }

    protected byte[] createChallenge() {
        return ByteArrayTools.createRandomBytes((int)32);
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public String getChallengeEncoded() {
        return new String(Base64.encode((byte[])this.challenge));
    }

    private void init() throws ObjectCreationException {
        try {
            this.certificate = (IX509PublicKeyCertificate)CertificateProviderTools.getCertificate((IArgs)this.getArgs(), (String)"certificate", (ICertificateProvider)CertificateProvider.get());
            this.challenge = this.createChallenge();
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }
}

