/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.smartcard;

import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.AuthenticationFailed;
import de.intarsys.aaa.authenticate.api.ICredentialSpec;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.aaa.authenticate.impl.CommonCredentialVerifier;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationState;
import de.intarsys.security.auth.module.smartcard.SmartcardCredential;
import de.intarsys.security.auth.module.smartcard.SmartcardCredentialSpec;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import java.security.GeneralSecurityException;
import java.security.PublicKey;

public class SmartcardCredentialVerifier
extends CommonCredentialVerifier<SmartcardCredentialSpec, SmartcardCredential> {
    public SmartcardCredentialVerifier(SmartcardCredentialSpec spec) {
        super((ICredentialSpec)spec);
    }

    protected void basicVerify(CommonAuthenticationState state, SmartcardCredential credential) throws AuthenticationException {
        SmartcardAuthenticationState smartcardState = (SmartcardAuthenticationState)state;
        try {
            IX509PublicKeyCertificate certificate = X509CertificateFactory.get().createPublicKeyCertificate(credential.getCertificate());
            if (!PpkTools.validate((byte[])credential.getResponse(), (PublicKey)certificate.getPublicKey(), null, (byte[])smartcardState.getChallenge())) {
                throw new AuthenticationFailed("Invalid challenge signature!");
            }
            if (smartcardState.getCertificate() != null && !smartcardState.getCertificate().equals(certificate)) {
                throw new AuthenticationFailed("Unauthorized certificate!");
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationFailed((Throwable)e);
        }
    }
}

