/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.module.test;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationContext;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.security.auth.module.test.PACKAGE;
import de.intarsys.security.auth.module.test.TestAuthenticationModule;
import de.intarsys.security.auth.module.test.TestCredential;
import de.intarsys.security.auth.module.test.TestCredentialSpec;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuthenticationContext
extends CommonAuthenticationContext {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(TestAuthenticationContext.class);

    public TestAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        super(authenticationModule, subject);
    }

    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        IConversation conversation = this.createConversation(authenticationArgs);
        TestAuthenticationModule.ActiveConversation.set(conversation);
        TestAuthenticationModule.ActiveConversationCount.incrementAndGet();
        conversation.whenComplete((result, ex) -> {
            TestAuthenticationModule.ActiveConversation.set(null);
            TestAuthenticationModule.ActiveConversationCount.decrementAndGet();
        });
        try {
            CommonAuthenticationState state = this.createState(conversation, authenticationArgs);
            TestCredentialSpec pinSpec = (TestCredentialSpec)this.getAuthenticationModule().getCredentialSpec();
            if ("external".equals(pinSpec.getChannel())) {
                conversation.setReplyStage((IReplyStage)new ProcessingStage());
            } else {
                conversation.completeExceptionally((Throwable)new IllegalArgumentException("unknown channel " + pinSpec.getChannel()));
            }
        }
        catch (Exception e) {
            conversation.completeExceptionally((Throwable)e);
        }
        return conversation;
    }

    protected ICredential convertToCredential(Object ack) throws AuthenticationException {
        if (ack instanceof String) {
            String value = (String)ack;
            if (StringTools.isEmpty((String)value)) {
                throw new AuthenticationCanceled();
            }
            return TestCredential.create(this.getAuthenticationModule().getCredentialSpec(), value);
        }
        return super.convertToCredential(ack);
    }

    public TestAuthenticationModule getAuthenticationModule() {
        return (TestAuthenticationModule)super.getAuthenticationModule();
    }
}

