/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.auth.service.impl;

import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.conversation.service.component.api.ResponseResume;
import de.intarsys.security.auth.module.smartcard.SmartcardAuthenticationState;
import de.intarsys.security.auth.module.smartcard.SmartcardCredential;
import de.intarsys.security.auth.service.api.RequestCancel;
import de.intarsys.security.auth.service.api.RequestGetPinParameters;
import de.intarsys.security.auth.service.api.RequestGetSmartcardParameters;
import de.intarsys.security.auth.service.api.RequestSetPin;
import de.intarsys.security.auth.service.api.RequestSetResponse;
import de.intarsys.security.auth.service.api.ResponseGetPinParameters;
import de.intarsys.security.auth.service.api.ResponseGetSmartcardParameters;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationRegistry;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.presentation.PresentationAdapter;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/authentication")
@Component
@ServiceImplementor
public class SvcAuthentication {
    @Autowired
    private IConversationRegistry conversationRegistry;

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/credential/cancel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseResume cancel(RequestCancel request) throws Exception {
        String conversationHandle = request.getState();
        IConversation conversation = this.getConversationRegistry().getConversation(conversationHandle);
        conversation.cancel(false);
        URI redirectUri = ConversationServiceTools.resume((IConversation)conversation, null);
        return new ResponseResume(redirectUri.toString());
    }

    public IConversationRegistry getConversationRegistry() {
        return this.conversationRegistry;
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getPinParameters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseGetPinParameters getPinParameters(RequestGetPinParameters request) throws Exception {
        String conversationHandle = request.getState();
        IConversation conversation = this.getConversationRegistry().getConversation(conversationHandle);
        CommonAuthenticationState authState = CommonAuthenticationState.getAuthState((IAttributeSupport)conversation);
        if (authState == null) {
            throw new InvalidRequestException("unknown credential");
        }
        ResponseGetPinParameters response = new ResponseGetPinParameters();
        response.setLabel(PresentationAdapter.create((Object)authState, (String)"Credentials required").getLabel());
        response.setDescription(PresentationAdapter.create((Object)authState, (String)"Please enter your credentials").getDescription());
        return response;
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getSmartcardParameters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseGetSmartcardParameters getSmartcardParameters(RequestGetSmartcardParameters request) throws Exception {
        String conversationHandle = request.getState();
        IConversation conversation = this.getConversationRegistry().getConversation(conversationHandle);
        CommonAuthenticationState authState = CommonAuthenticationState.getAuthState((IAttributeSupport)conversation);
        if (authState == null) {
            throw new InvalidRequestException("unknown credential");
        }
        ResponseGetSmartcardParameters response = new ResponseGetSmartcardParameters();
        response.setLabel(PresentationAdapter.create((Object)authState, (String)"Credentials required").getLabel());
        response.setDescription(PresentationAdapter.create((Object)authState, (String)"Please enter your credentials").getDescription());
        response.setChallenge(((SmartcardAuthenticationState)authState).getChallengeEncoded());
        return response;
    }

    public void setConversationRegistry(IConversationRegistry conversationRegistry) {
        this.conversationRegistry = conversationRegistry;
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/credential/setPin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseResume setPin(RequestSetPin request) throws Exception {
        String conversationHandle = request.getState();
        IConversation conversation = this.getConversationRegistry().getConversation(conversationHandle);
        CommonAuthenticationState state = CommonAuthenticationState.getAuthState((IAttributeSupport)conversation);
        state.getAuthenticationContext().verify(state, (Object)request.getValue());
        URI redirectUri = ConversationServiceTools.resume((IConversation)conversation, null);
        return new ResponseResume(redirectUri.toString());
    }

    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/credential/setResponse")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ResponseResume setResponse(RequestSetResponse request) throws Exception {
        String conversationHandle = request.getState();
        IConversation conversation = this.getConversationRegistry().getConversation(conversationHandle);
        CommonAuthenticationState state = CommonAuthenticationState.getAuthState((IAttributeSupport)conversation);
        SmartcardCredential credential = null;
        if (!StringTools.isEmpty((String)request.getResponse())) {
            byte[] response = Base64.decode((String)request.getResponse());
            byte[] certificate = Base64.decode((String)request.getCertificate());
            credential = SmartcardCredential.create(state.getAuthenticationContext().getAuthenticationModule().getCredentialSpec(), response, certificate);
        }
        state.getAuthenticationContext().verify(state, credential);
        URI redirectUri = ConversationServiceTools.resume((IConversation)conversation, null);
        return new ResponseResume(redirectUri.toString());
    }
}

