/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCardHolderApplication;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractAuthenticateApp
extends AbstractCardHolderApplication
implements IAuthenticateApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private int maximumChallengeLength = 64;

    protected abstract byte[] basicSign(byte[] var1) throws CardApplicationException;

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IAuthenticateApplication.class;
    }

    protected String getDefaultEncodingSchemeName() {
        return "PKCS1Type1";
    }

    @Override
    public String getEncryptionAlgorithmName() {
        if (this.getCardHolderCertificate() != null) {
            return this.getCardHolderCertificate().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        Iterator<CardApplicationBinding> iterator = this.getBindings().iterator();
        if (iterator.hasNext()) {
            CardApplicationBinding binding = iterator.next();
            return binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        return null;
    }

    @Override
    public int getMaximumChallengeLength() {
        return this.maximumChallengeLength;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "AuthenticateApp";
    }

    @Override
    public Collection<String> getSupportedEncryptionAlgorithmNames() {
        HashSet<String> names = new HashSet<String>();
        for (CardApplicationBinding binding : this.getBindings()) {
            names.add(binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName());
        }
        return names;
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setMaximumChallengeLength(ElementTools.getInt((IElement)this.getConfiguration(), (String)"maxChallenge", (int)this.getMaximumChallengeLength()));
        this.setRestrictionCount(this.getCardProduct().getGlobalRestriction(this.getCardConnection()));
    }

    public void setMaximumChallengeLength(int maximumChallengeLength) {
        this.maximumChallengeLength = maximumChallengeLength;
    }

    @Override
    public final byte[] sign(byte[] data) throws CardApplicationException {
        this.authenticate();
        try {
            this.incUseCount();
            byte[] byArray = this.basicSign(data);
            return byArray;
        }
        catch (CardApplicationException e) {
            this.basicResetSecurityState();
            throw e;
        }
        finally {
            this.basicOperationCleanup();
        }
    }
}

