/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.security.smartcard.model.cmd.ICmdManageSecurityEnvironment;
import de.intarsys.security.smartcard.model.cmd.ICmdPerformSecurityOperation;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCardHolderApplication
extends CardApplicationAdapter
implements ICardHolderApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Collection<String> DIGEST_ALGORITHMS_ALL = Collections.unmodifiableCollection(Arrays.asList("SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256"));
    public static final Collection<String> DIGEST_ALGORITHMS_SHA1 = Collections.unmodifiableCollection(Arrays.asList("SHA-1"));
    public static final Collection<String> DIGEST_ALGORITHMS_SHA1_SHA256_RIPEMD160 = Collections.unmodifiableCollection(Arrays.asList("SHA-1", "SHA-256", "RIPEMD160"));
    public static final Collection<String> DIGEST_ALGORITHMS_SHA256 = Collections.unmodifiableCollection(Arrays.asList("SHA-256"));
    public static final Collection<String> DIGEST_ALGORITHMS_SHA1_SHA256_RIPEMD160_RIPEMD256 = Collections.unmodifiableCollection(Arrays.asList("SHA-1", "SHA-256", "RIPEMD160", "RIPEMD256"));
    public static final Collection<String> ENCRYPTION_ALGORITHMS_ALL = Collections.unmodifiableCollection(Arrays.asList("RSA", "ECDSA", "EC"));
    public static final Collection<String> ENCRYPTION_ALGORITHMS_RSA = Collections.unmodifiableCollection(Arrays.asList("RSA"));
    public static final Collection<String> ENCRYPTION_ALGORITHMS_ECDSA = Collections.unmodifiableCollection(Arrays.asList("ECDSA"));
    public static final Collection<String> ENCRYPTION_ALGORITHMS_EC = Collections.unmodifiableCollection(Arrays.asList("EC"));
    public static final Collection<String> ENCODING_SCHEMES_ALL = Collections.unmodifiableCollection(Arrays.asList("PKCS1Type1", "X509", "ISO9796-2-S1"));
    public static final Collection<String> ENCODING_SCHEMES_PKCS1Type1 = Collections.unmodifiableCollection(Arrays.asList("PKCS1Type1"));
    public static final Collection<String> ENCODING_SCHEMES_X509 = Collections.unmodifiableCollection(Arrays.asList("X509"));
    public static final Collection<String> ENCODING_SCHEMES_ISO9796_2_S1 = Collections.unmodifiableCollection(Arrays.asList("ISO9796-2-S1"));
    private int useCount = 0;
    private Collection<ICardHolderCertificate> cardHolderCertificates;
    private ICardHolderCertificate cardHolderCertificate;

    protected void basicOperationCleanup() throws CardApplicationException {
        if (this.getRestrictionCount() != -1 && this.getUseCount() >= this.getRestrictionCount()) {
            this.basicResetSecurityState();
        }
    }

    @Override
    protected void basicResetSecurityStateCard() {
        try {
            this.cmdMseRestore(1);
        }
        catch (CardApplicationException cardApplicationException) {
            // empty catch block
        }
    }

    @Override
    protected void basicResetUseCount() {
        this.useCount = 0;
    }

    protected ResponseAPDU cmdMseSetComponentAlgoRef(int component, int algoRef) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createSetComponentAlgoRef(component, algoRef);
        return this.sendRequest(mse, req);
    }

    protected ResponseAPDU cmdMseSetComponentKey(int component, byte[] prKeyId) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createSetComponentKey(component, prKeyId);
        return this.sendRequest(mse, req);
    }

    protected ResponseAPDU cmdMseSetComponentKeyAlgo(int component, byte[] prKeyId, byte[] algorithmId) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createSetComponentKeyAlgo(component, prKeyId, algorithmId);
        return this.sendRequest(mse, req);
    }

    protected ResponseAPDU cmdMseSetComponentKeyAlgoRef(int component, byte[] prKeyId, int algoRef) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createSetComponentKeyAlgoRef(component, prKeyId, algoRef);
        return this.sendRequest(mse, req);
    }

    protected ResponseAPDU cmdMseSetTemplate(IMechanism mechanism, byte[] prKeyId) throws CardApplicationException {
        int component;
        if ("DST".equals(mechanism.getOperation())) {
            component = 182;
        } else if ("AT".equals(mechanism.getOperation())) {
            component = 164;
        } else if ("CT".equals(mechanism.getOperation())) {
            component = 184;
        } else {
            throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
        }
        if (mechanism.getAlgorithmRef() != -1) {
            return this.cmdMseSetComponentKeyAlgoRef(component, prKeyId, mechanism.getAlgorithmRef());
        }
        if (mechanism.getSecurityEnvironment() != -1) {
            return this.cmdMseRestore(mechanism.getSecurityEnvironment());
        }
        if (mechanism.getAlgorithmId() != null) {
            byte[] algoId = HexTools.hexStringToBytes((String)mechanism.getAlgorithmId());
            return this.cmdMseSetComponentKeyAlgo(component, prKeyId, algoId);
        }
        return this.cmdMseSetComponentKey(component, prKeyId);
    }

    protected ResponseAPDU cmdPsoComputeDigitalSignature(byte[] message) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createComputeDigitalSignature(message);
        return this.sendRequest(pso, req);
    }

    protected ResponseAPDU cmdPsoComputeDigitalSignature(byte[] message, int keyByteSize) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createComputeDigitalSignature(message, keyByteSize);
        return this.sendRequest(pso, req);
    }

    protected ResponseAPDU cmdPsoDecipher(byte[] cryptogram, int paddingIndicator, int keyByteSize) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createDecipher(cryptogram, paddingIndicator, keyByteSize);
        return this.sendRequest(pso, req);
    }

    protected ResponseAPDU cmdPsoHashUpload(byte[] digest) throws CardApplicationException {
        ICmdPerformSecurityOperation pso = this.getCommand(ICmdPerformSecurityOperation.class);
        RequestAPDU req = pso.createHashUpload(digest);
        return this.sendRequest(pso, req);
    }

    protected IMechanism createDefaultMechanism() {
        return null;
    }

    protected IMechanism detectMechanism() throws CardApplicationException {
        String[] operationPrecedence;
        ICardHolderCertificate active = this.getCardHolderCertificate();
        if (active == null) {
            return null;
        }
        CardApplicationBinding binding = this.lookupBinding(active);
        if (binding == null) {
            return this.createDefaultMechanism();
        }
        List<IMechanism> mechanisms = binding.getMechanisms();
        for (String operation : operationPrecedence = this.getMechanismPrecedence()) {
            for (IMechanism aMechanism : mechanisms) {
                if (!operation.equals(aMechanism.getOperation()) && !operation.equals("ANY") || !this.detectMechanismSupports(aMechanism)) continue;
                return aMechanism;
            }
        }
        return this.createDefaultMechanism();
    }

    protected boolean detectMechanismSupports(IMechanism aMechanism) throws CardApplicationException {
        return true;
    }

    @Override
    protected CardFileSelector getAuthenticationPath() {
        return this.getApplicationPath();
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        if (this.getCardHolderCertificate() != null) {
            return this.getCardHolderCertificate().getPinInfo();
        }
        return null;
    }

    @Override
    protected IMessage getAuthenticationPromptExpanded(boolean securePinEntry) {
        String code = this.getMsgPromptCodeAuthentication();
        return this.getAuthenticationPrompt(code, this.getAuthenticationPrompt(), this.getCard(), this.getAuthenticationPinInfo(), this.getCardHolderCertificate(), securePinEntry);
    }

    @Override
    public ICardHolderCertificate getCardHolderCertificate() {
        return this.cardHolderCertificate;
    }

    protected String[] getMechanismPrecedence() {
        return new String[]{"ANY"};
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    public Collection<ICardHolderCertificate> getSupportedCardHolderCertificates() {
        if (this.cardHolderCertificates == null) {
            this.cardHolderCertificates = this.createCardHolderCertificates(this.getBindings());
        }
        return this.cardHolderCertificates;
    }

    public int getUseCount() {
        return this.useCount;
    }

    protected void incUseCount() {
        ++this.useCount;
    }

    protected CardApplicationBinding lookupBinding(ICardHolderCertificate active) {
        for (CardApplicationBinding binding : this.getBindings()) {
            if (binding.getCardHolderCertificateInfo() != active.getInfo()) continue;
            return binding;
        }
        return null;
    }

    @Override
    public void setCardHolderCertificate(ICardHolderCertificate cardHolderCertificate) {
        this.cardHolderCertificate = cardHolderCertificate;
    }
}

