/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCredentialApp;
import de.intarsys.security.smartcard.app.common.IChangeCredentialApplication;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChangeCredentialApp
extends AbstractCredentialApp
implements IChangeCredentialApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(AbstractChangeCredentialApp.class);
    private boolean sameValueForAllPins = false;
    private Secret oldPin;
    private Secret newPin;
    private boolean enterCurrentPin = true;

    protected void basicChangeCredentialGui() throws CardApplicationException {
        Secret repeatPin;
        IMessage title = this.getMsgTitleOld(false);
        IMessage prompt = this.getMsgPromptOld(false);
        Secret tmpOldPin = this.queryPin(title, prompt);
        title = this.getMsgTitleNew(false);
        prompt = this.getMsgPromptNew(false);
        Secret tmpNewPin = this.queryPin(title, prompt);
        if (!LangTools.equals((Object)tmpNewPin, (Object)(repeatPin = this.queryPin(title = this.getMsgTitleRepeat(false), prompt = this.getMsgPromptRepeat(false))))) {
            throw new CardAuthenticationFailedException(this.getMessage("AbstractChangeCredentialApp.error.PinMismatch", new Object[0]).getString());
        }
        if (this.isSameValueForAllPins()) {
            for (IPinInfo pinInfo : this.getSupportedPinInfos()) {
                this.setPinInfo(pinInfo);
                Log.info("set all pins to same value, changing pin " + this.getPinInfo().getLabel());
                this.basicChangeCredentialLiteral(tmpOldPin, tmpNewPin);
            }
        } else {
            this.basicChangeCredentialLiteral(tmpOldPin, tmpNewPin);
        }
    }

    protected void basicChangeCredentialLiteral(Secret oldPin, Secret newPin) throws CardApplicationException {
        ICmdChangeReferenceData cmd;
        boolean explicit;
        block5: {
            this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
            if (!this.isVerified(this.getPinInfo())) {
                try {
                    this.cmdVerify(this.getPinInfo(), oldPin);
                }
                catch (CardStatusCodeException e) {
                    int sw1 = e.getSw1();
                    int sw2 = e.getSw2();
                    if (sw1 == 105 && sw2 == 132 || sw1 == 105 && sw2 == 133 || sw1 == 106 && sw2 == 128) break block5;
                    throw e;
                }
            }
        }
        if (explicit = (cmd = this.getCommand(ICmdChangeReferenceData.class)).isExplicitModeSupported()) {
            this.cmdChangeCredential(this.getPinInfo(), newPin);
        } else {
            this.cmdChangeCredential(this.getPinInfo(), this.getPinInfo().getPinCodec(), oldPin, newPin);
        }
    }

    protected void basicChangeCredentialSpe() throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        IPinCodec pinCodec = this.getPinInfo().getPinCodec();
        ICmdChangeReferenceData cmdModify = this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = this.isEnterCurrentPin() ? cmdModify.create(this.getPinInfo().getReference(), pinCodec.getTemplate(), pinCodec.getTemplate()) : cmdModify.create(this.getPinInfo().getReference(), pinCodec.getTemplate());
        boolean indirect = this.getPinEntryApplication().supportsPinModifyIndirect(this.getPinInfo().getPinCodec());
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, pinCodec, this.isEnterCurrentPin(), this.getMsgPrompts(indirect));
        this.getCardProduct().checkResponse(template, response);
    }

    @Override
    public void changeCredential() throws CardApplicationException {
        this.basicBeginTransaction();
        if (!CryptoTools.isEmpty((Secret)this.getNewPin())) {
            if (this.isSameValueForAllPins()) {
                for (IPinInfo pinInfo : this.getSupportedPinInfos()) {
                    this.setPinInfo(pinInfo);
                    Log.info("set all pins to same value, changing pin " + this.getPinInfo().getLabel());
                    this.basicChangeCredentialLiteral(this.getOldPin(), this.getNewPin());
                }
            } else {
                this.basicChangeCredentialLiteral(this.getOldPin(), this.getNewPin());
            }
        } else if (this.isSupportedSPE()) {
            this.basicChangeCredentialSpe();
        } else {
            if (this.isEnforceSPE() && !this.isSameValueForAllPins()) {
                throw new SpeRequiredException();
            }
            this.basicChangeCredentialGui();
        }
    }

    @Override
    protected IPinInfo[] filterPinInfos(IPinInfo[] pinInfos) throws CardApplicationException {
        ArrayList<IPinInfo> result = new ArrayList<IPinInfo>();
        IPinStateApplication pinStateApp = this.getCardProduct().createCardApplication(this.getCardConnection(), IPinStateApplication.class);
        for (IPinInfo pinInfo : pinInfos) {
            if (pinInfo.isFixed() || !pinStateApp.getPinState(pinInfo).isChangeable()) continue;
            result.add(pinInfo);
        }
        return result.toArray(new IPinInfo[result.size()]);
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IChangeCredentialApplication.class;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "ChangeCredentialApp";
    }

    protected IMessage getMsgPromptDirect() {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IPinCodec codec = this.getPinInfo().getPinCodec();
        String minLength = String.valueOf(codec.getMinCharacters());
        String maxLength = String.valueOf(codec.getMaxCharacters());
        IMessage plainMsg = this.getMessage("AbstractChangeCredentialApp.pinDirect.promptSPE", terminalLabel, pinLabel, minLength, maxLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptNew(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IPinCodec codec = this.getPinInfo().getPinCodec();
        String minLength = String.valueOf(codec.getMinCharacters());
        String maxLength = String.valueOf(codec.getMaxCharacters());
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractChangeCredentialApp.pinNew.promptSPE", terminalLabel, pinLabel, minLength, maxLength) : this.getMessage("AbstractChangeCredentialApp.pinNew.promptGUI", terminalLabel, pinLabel, minLength, maxLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptOld(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractChangeCredentialApp.pinOld.promptSPE", terminalLabel, pinLabel) : this.getMessage("AbstractChangeCredentialApp.pinOld.promptGUI", terminalLabel, pinLabel);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptRepeat(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractChangeCredentialApp.pinRepeat.promptSPE", terminalLabel, pinLabel) : this.getMessage("AbstractChangeCredentialApp.pinRepeat.promptGUI", terminalLabel, pinLabel);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage[] getMsgPrompts(boolean indirect) throws CardApplicationException {
        ArrayList<IMessage> messages = new ArrayList<IMessage>(3);
        if (indirect) {
            if (this.isEnterCurrentPin()) {
                messages.add(this.getMsgPromptOld(true));
            }
            messages.add(this.getMsgPromptNew(true));
            messages.add(this.getMsgPromptRepeat(true));
        } else if (this.isEnterCurrentPin()) {
            messages.add(this.getMsgPromptDirect());
        } else {
            messages.add(this.getMsgPromptNew(true));
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    protected IMessage getMsgTitleNew(boolean securePinEntry) {
        return this.getMessage("AbstractChangeCredentialApp.pinNew.title", new Object[0]);
    }

    protected IMessage getMsgTitleOld(boolean securePinEntry) {
        return this.getMessage("AbstractChangeCredentialApp.pinOld.title", new Object[0]);
    }

    protected IMessage getMsgTitleRepeat(boolean securePinEntry) {
        return Msg.getMessage("AbstractChangeCredentialApp.pinRepeat.title", new Object[0]);
    }

    public Secret getNewPin() {
        return this.newPin;
    }

    public Secret getOldPin() {
        return this.oldPin;
    }

    public boolean isEnterCurrentPin() {
        return this.enterCurrentPin;
    }

    @Override
    public boolean isSameValueForAllPins() {
        return this.sameValueForAllPins;
    }

    @Override
    public boolean isSupportedSPE() {
        try {
            return this.getPinEntryApplication().supportsPinModify(this.getPinInfo().getPinCodec()) && !this.isDisableSPE() && !this.isSameValueForAllPins();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }

    public void setEnterCurrentPin(boolean enterCurrentPin) {
        this.enterCurrentPin = enterCurrentPin;
    }

    @Override
    public void setNewPin(Secret newPin) {
        this.newPin = newPin;
    }

    @Override
    public void setOldPin(Secret oldPin) {
        this.oldPin = oldPin;
    }

    @Override
    public void setSameValueForAllPins(boolean sameValueForAllPins) {
        this.sameValueForAllPins = sameValueForAllPins;
    }
}

