/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.crypto.Secret;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractCompositeCardHolderApplication
extends CardApplicationAdapter
implements ICardHolderApplication {
    private final List<ICardHolderApplication> cardHolderApplications = new ArrayList<ICardHolderApplication>();
    private ICardHolderApplication selectedApplication = null;

    public void addCardHolderApplication(ICardHolderApplication app) {
        if (app == null) {
            return;
        }
        this.cardHolderApplications.add(app);
    }

    @Override
    public void authenticate() throws CardApplicationException {
        if (this.getSelectedApplication() != null) {
            try {
                this.getSelectedApplication().authenticate();
            }
            catch (CardAuthenticationFailedException e) {
                this.setAuthenticationPin(null);
                throw e;
            }
            return;
        }
        throw new IllegalArgumentException("credential doesn't belong to this application");
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        if (this.getSelectedApplication() == null) {
            return null;
        }
        return this.getSelectedApplication().getAuthenticationPinInfo();
    }

    public List<ICardHolderApplication> getCardHolderApplications() {
        return this.cardHolderApplications;
    }

    @Override
    public ICardHolderCertificate getCardHolderCertificate() {
        if (this.getSelectedApplication() != null) {
            return this.getSelectedApplication().getCardHolderCertificate();
        }
        return null;
    }

    protected ICardHolderApplication getSelectedApplication() {
        return this.selectedApplication;
    }

    public List<ICardHolderCertificate> getSupportedCardHolderCertificates() {
        HashSet<ICardHolderCertificate> merged = new HashSet<ICardHolderCertificate>();
        for (ICardHolderApplication app : this.cardHolderApplications) {
            merged.addAll(app.getSupportedCardHolderCertificates());
        }
        return new ArrayList<ICardHolderCertificate>(merged);
    }

    @Override
    public void setAuthenticationPin(Secret secret) {
        super.setAuthenticationPin(secret);
        for (ICardHolderApplication app : this.cardHolderApplications) {
            app.setAuthenticationPin(secret);
        }
    }

    @Override
    public void setAuthenticationPrompt(String msg) {
        super.setAuthenticationPrompt(msg);
        for (ICardHolderApplication app : this.getCardHolderApplications()) {
            app.setAuthenticationPrompt(msg);
        }
    }

    @Override
    public void setCardHolderCertificate(ICardHolderCertificate cert) {
        this.selectedApplication = null;
        for (ICardHolderApplication app : this.cardHolderApplications) {
            if (app.getSupportedCardHolderCertificates().contains(cert)) {
                app.setCardHolderCertificate(cert);
                this.selectedApplication = app;
                continue;
            }
            app.setCardHolderCertificate(null);
        }
    }
}

