/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.security.smartcard.model.cmd.ICmdResetRetryCounter;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessageBundle;
import java.security.GeneralSecurityException;

public abstract class AbstractCredentialApp
extends CardApplicationAdapter {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IPinInfo pinInfo;

    protected ResponseAPDU cmdChangeCredential(IPinInfo pinInfo, IPinCodec pinCodec, Secret secret, Secret newSecret) throws CardApplicationException {
        byte[] newSecretBlock;
        byte[] secretBlock;
        try {
            secretBlock = pinCodec.encode(secret.getChars());
            newSecretBlock = pinCodec.encode(newSecret.getChars());
        }
        catch (GeneralSecurityException e) {
            throw CardApplicationException.create(e);
        }
        ICmdChangeReferenceData cmd = this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU req = cmd.create(pinInfo.getReference(), secretBlock, newSecretBlock);
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdChangeCredential(IPinInfo pinRef, Secret newSecret) throws CardApplicationException {
        byte[] newSecretBlock;
        IPinCodec pinCodec = pinRef.getPinCodec();
        try {
            newSecretBlock = pinCodec.encode(newSecret.getChars());
        }
        catch (GeneralSecurityException e) {
            throw CardApplicationException.create(e);
        }
        ICmdChangeReferenceData cmd = this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU req = cmd.create(pinRef.getReference(), newSecretBlock);
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdResetRetryCounter(IPinInfo pinInfo) throws CardApplicationException {
        ICmdResetRetryCounter cmd = this.getCommand(ICmdResetRetryCounter.class);
        RequestAPDU req = cmd.create(pinInfo.getReference());
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdResetRetryCounter(IPinInfo pinInfo, byte[] resettingCodeEncoded) throws CardApplicationException {
        ICmdResetRetryCounter cmd = this.getCommand(ICmdResetRetryCounter.class);
        RequestAPDU req = cmd.createWithResettingCode(pinInfo.getReference(), resettingCodeEncoded);
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdResetRetryCounter(IPinInfo pinInfo, byte[] resettingCodeEncoded, byte[] newSecretEncoded) throws CardApplicationException {
        ICmdResetRetryCounter cmd = this.getCommand(ICmdResetRetryCounter.class);
        RequestAPDU req = cmd.create(pinInfo.getReference(), resettingCodeEncoded, newSecretEncoded);
        return this.sendRequest(cmd, req);
    }

    protected IPinInfo[] filterPinInfos(IPinInfo[] pinInfos) throws CardApplicationException {
        return pinInfos;
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return this.getPinInfo();
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    public IPinInfo getPinInfo() {
        return this.pinInfo;
    }

    public void setPinInfo(IPinInfo pinInfo) {
        this.pinInfo = pinInfo;
    }
}

