/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.encoding.PKCS1Type2Encoding;
import de.intarsys.security.smartcard.app.common.AbstractCardHolderApplication;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractDecryptApp
extends AbstractCardHolderApplication
implements IDecryptApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected abstract byte[] basicDecrypt(byte[] var1) throws CardApplicationException;

    protected byte[] createPSOOutput(byte[] data, IMechanism mechanism) throws CardApplicationException {
        String name = mechanism.getOutputEncodingAlgorithmName();
        if (name == null) {
            return data;
        }
        if ("Raw".equals(name)) {
            return data;
        }
        if ("PKCS1Type2".equals(name)) {
            PKCS1Type2Encoding encoding = new PKCS1Type2Encoding();
            try {
                return encoding.decode(data);
            }
            catch (IOException e) {
                throw CardApplicationException.create(e);
            }
        }
        throw new CardApplicationException("encoding " + name + " not supported");
    }

    @Override
    public final byte[] decrypt(byte[] bytes) throws CardApplicationException {
        this.authenticate();
        try {
            this.incUseCount();
            byte[] byArray = this.basicDecrypt(bytes);
            return byArray;
        }
        catch (CardApplicationException e) {
            this.basicResetSecurityState();
            throw e;
        }
        finally {
            this.basicOperationCleanup();
        }
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IDecryptApplication.class;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        if (this.getCardHolderCertificate() != null) {
            return this.getCardHolderCertificate().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        Iterator<CardApplicationBinding> iterator = this.getBindings().iterator();
        if (iterator.hasNext()) {
            CardApplicationBinding binding = iterator.next();
            return binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        return null;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "DecryptApp";
    }

    @Override
    public Collection<String> getSupportedEncryptionAlgorithmNames() {
        HashSet<String> names = new HashSet<String>();
        for (CardApplicationBinding binding : this.getBindings()) {
            names.add(binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName());
        }
        return names;
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(this.getCardProduct().getGlobalRestriction(this.getCardConnection()));
    }
}

