/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.IExtractCertificateApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardCertificate;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractExtractCertificateApp
extends CardApplicationAdapter
implements IExtractCertificateApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Collection<ICardHolderCertificate> cardHolderCertificates;

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IExtractCertificateApplication.class;
    }

    @Override
    public List<ICardCertificate> getCertificates() {
        HashSet<ICardCertificate> certificates = new HashSet<ICardCertificate>();
        certificates.addAll(this.getSupportedCardHolderCertificates());
        for (ICardHolderCertificate cardHolderCertificate : this.getSupportedCardHolderCertificates()) {
            certificates.addAll(cardHolderCertificate.getAttributeCertificates());
            certificates.addAll(cardHolderCertificate.getCACertificates());
        }
        return new ArrayList<ICardCertificate>(certificates);
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "ExtractCertificateApp";
    }

    @Override
    public List<ICardPublicKeyCertificate> getPublicKeyCertificates() {
        HashSet<ICardPublicKeyCertificate> certificates = new HashSet<ICardPublicKeyCertificate>();
        certificates.addAll(this.getSupportedCardHolderCertificates());
        for (ICardHolderCertificate cardHolderCertificate : this.getSupportedCardHolderCertificates()) {
            certificates.addAll(cardHolderCertificate.getCACertificates());
        }
        ArrayList<ICardPublicKeyCertificate> result = new ArrayList<ICardPublicKeyCertificate>(certificates);
        CardCertificate.cachePKCardCertificates(this.getCard(), result);
        return result;
    }

    public Collection<ICardHolderCertificate> getSupportedCardHolderCertificates() {
        if (this.cardHolderCertificates == null) {
            this.cardHolderCertificates = this.createCardHolderCertificates(this.getBindings());
        }
        return this.cardHolderCertificates;
    }
}

