/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCredentialApp;
import de.intarsys.security.smartcard.app.common.IInitializeCredentialApplication;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.CommonPinCodec;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdChangeReferenceData;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import java.util.ArrayList;

public abstract class AbstractInitializeCredentialApp
extends AbstractCredentialApp
implements IInitializeCredentialApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Secret transportPin;
    private Secret newPin;
    private Secret[] newPins;

    protected void basicInitializeCredentialGui() throws CardApplicationException {
        Secret repeatPin;
        IMessage prompt;
        IMessage title;
        Secret tmpTransportPin = null;
        if (this.isTransportPinEntryRequired()) {
            title = this.getMsgTitleTransport(false);
            prompt = this.getMsgPromptTransport(false);
            tmpTransportPin = this.queryPin(title, prompt);
        }
        title = this.getMsgTitleNew(false);
        prompt = this.getMsgPromptNew(false);
        Secret tmpNewPin = this.queryPin(title, prompt);
        if (!LangTools.equals((Object)tmpNewPin, (Object)(repeatPin = this.queryPin(title = this.getMsgTitleRepeat(false), prompt = this.getMsgPromptRepeat(false))))) {
            throw new CardAuthenticationFailedException(this.getMessage("AbstractInitializeCredentialApp.error.PinMismatch", new Object[0]).getString());
        }
        this.basicInitializeCredentialLiteral(tmpTransportPin, tmpNewPin);
    }

    protected void basicInitializeCredentialLiteral(Secret pTransportPin, Secret pNewPin) throws CardApplicationException {
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        if (this.isEnterCurrentPin()) {
            if (this.getTransportPinStatic() != null) {
                pTransportPin = Secret.hide((char[])this.getTransportPinStatic());
            }
            this.cmdChangeCredential(this.getPinInfo(), this.getTransportPinCodec(), pTransportPin, pNewPin);
        } else {
            this.cmdChangeCredential(this.getPinInfo(), pNewPin);
        }
    }

    protected void basicInitializeCredentialSpe() throws CardApplicationException {
        CommonPinCodec transportPinCodec = this.getTransportPinCodec();
        ICmdChangeReferenceData cmdModify = this.getCommand(ICmdChangeReferenceData.class);
        RequestAPDU template = this.isEnterCurrentPin() || this.getTransportPinStatic() != null ? cmdModify.create(this.getPinInfo().getReference(), transportPinCodec.getTemplate(), transportPinCodec.getTemplate()) : cmdModify.create(this.getPinInfo().getReference(), transportPinCodec.getTemplate());
        boolean indirect = this.getPinEntryApplication().supportsPinModifyIndirect(transportPinCodec);
        IMessage[] messages = this.getMsgPrompts(indirect);
        this.getFileSystem().selectDf(this.getPinInfo().getDirectory(), false);
        ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, transportPinCodec, this.isEnterCurrentPin(), messages);
        this.getCardProduct().checkResponse(template, response);
    }

    @Override
    protected IPinInfo[] filterPinInfos(IPinInfo[] pinInfos) throws CardApplicationException {
        ArrayList<IPinInfo> result = new ArrayList<IPinInfo>();
        IPinStateApplication pinStateApp = this.getCardProduct().createCardApplication(this.getCardConnection(), IPinStateApplication.class);
        for (IPinInfo pinInfo : pinInfos) {
            PinState pinState = pinStateApp.getPinState(pinInfo);
            if (pinInfo.isFixed() || !pinState.isInitializable()) continue;
            result.add(pinInfo);
        }
        return result.toArray(new IPinInfo[result.size()]);
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IInitializeCredentialApplication.class;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "InitializeCredentialApp";
    }

    protected IMessage getMsgPromptDirect() throws CardApplicationException {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IPinCodec codec = this.getPinInfo().getPinCodec();
        String minLength = String.valueOf(codec.getMinCharacters());
        String maxLength = String.valueOf(codec.getMaxCharacters());
        String transportLabel = this.getPinInfo().getTransportLabel();
        String transportLength = String.valueOf(this.getPinInfo().getTransportLength());
        IMessage plainMsg = this.isTransportPinEntryRequired() ? this.getMessage("AbstractInitializeCredentialApp.pinDirectEnterTransport.promptSPE", terminalLabel, pinLabel, minLength, maxLength, transportLabel, transportLength) : this.getMessage("AbstractInitializeCredentialApp.pinDirectStaticTransport.promptSPE", terminalLabel, pinLabel, minLength, maxLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptNew(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IPinCodec codec = this.getPinInfo().getPinCodec();
        String minLength = String.valueOf(codec.getMinCharacters());
        String maxLength = String.valueOf(codec.getMaxCharacters());
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractInitializeCredentialApp.pinNew.promptSPE", terminalLabel, pinLabel, minLength, maxLength) : this.getMessage("AbstractInitializeCredentialApp.pinNew.promptGUI", terminalLabel, pinLabel, minLength, maxLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptRepeat(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractInitializeCredentialApp.pinRepeat.promptSPE", terminalLabel, pinLabel) : this.getMessage("AbstractInitializeCredentialApp.pinRepeat.promptGUI", terminalLabel, pinLabel);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage[] getMsgPrompts(boolean indirect) throws CardApplicationException {
        ArrayList<IMessage> messages = new ArrayList<IMessage>(3);
        if (indirect) {
            if (this.isTransportPinEntryRequired()) {
                messages.add(this.getMsgPromptTransport(true));
            }
            messages.add(this.getMsgPromptNew(true));
            messages.add(this.getMsgPromptRepeat(true));
        } else {
            messages.add(this.getMsgPromptDirect());
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    protected IMessage getMsgPromptTransport(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String transportLabel = this.getPinInfo().getTransportLabel();
        String transportLength = String.valueOf(this.getPinInfo().getTransportLength());
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractInitializeCredentialApp.pinTransport.promptSPE", terminalLabel, transportLabel, transportLength) : this.getMessage("AbstractInitializeCredentialApp.pinTransport.promptGUI", terminalLabel, transportLabel, transportLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgTitleNew(boolean securePinEntry) {
        return this.getMessage("AbstractInitializeCredentialApp.pinNew.title", new Object[0]);
    }

    protected IMessage getMsgTitleRepeat(boolean securePinEntry) {
        return Msg.getMessage("AbstractInitializeCredentialApp.pinRepeat.title", new Object[0]);
    }

    protected IMessage getMsgTitleTransport(boolean securePinEntry) {
        String transportLabel = this.getPinInfo().getTransportLabel();
        String transportLength = String.valueOf(this.getPinInfo().getTransportLength());
        return this.getMessage("AbstractInitializeCredentialApp.pinTransport.title", transportLabel, transportLength);
    }

    public Secret getNewPin() {
        return this.newPin;
    }

    public Secret[] getNewPins() {
        return this.newPins;
    }

    public Secret getTransportPin() {
        return this.transportPin;
    }

    protected CommonPinCodec getTransportPinCodec() throws CardApplicationException {
        CommonPinCodec transportPinCodec = (CommonPinCodec)this.getPinInfo().getPinCodec().clone();
        if (this.getPinInfo().getTransportLength() != -1) {
            transportPinCodec.setMinCharacters(this.getPinInfo().getTransportLength());
        }
        return transportPinCodec;
    }

    protected char[] getTransportPinStatic() throws CardApplicationException {
        if (this.getPinInfo() == null) {
            return null;
        }
        return this.getPinInfo().getTransportValue();
    }

    @Override
    public void initializeCredential() throws CardApplicationException {
        this.basicBeginTransaction();
        if (!CryptoTools.isEmpty((Secret)this.getNewPin())) {
            this.basicInitializeCredentialLiteral(this.getTransportPin(), this.getNewPin());
        } else if (this.isSupportedSPE()) {
            this.basicInitializeCredentialSpe();
        } else {
            if (this.isEnforceSPE()) {
                throw new SpeRequiredException();
            }
            this.basicInitializeCredentialGui();
        }
    }

    public boolean isEnterCurrentPin() throws CardApplicationException {
        return this.isTransportPinEntryRequired();
    }

    @Override
    public boolean isSupportedSPE() {
        try {
            return this.getPinEntryApplication().supportsPinModify(this.getPinInfo().getPinCodec()) && !this.isDisableSPE();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }

    protected boolean isTransportPinEntryRequired() throws CardApplicationException {
        return this.getTransportPinStatic() == null;
    }

    @Override
    public void setNewPin(Secret newPin) {
        this.newPin = newPin;
    }

    @Override
    public void setNewPins(Secret[] newPins) {
        this.newPins = newPins;
    }

    @Override
    public void setTransportPin(Secret transportPin) {
        this.transportPin = transportPin;
    }
}

