/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCredentialApp;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.app.common.IResetCredentialApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.common.CommonPinCodec;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.SpeRequiredException;
import de.intarsys.security.smartcard.model.cmd.ICmdResetRetryCounter;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import java.security.GeneralSecurityException;
import java.util.ArrayList;

public abstract class AbstractResetCredentialApp
extends AbstractCredentialApp
implements IResetCredentialApplication {
    public static final String EA_P2_REFERENCES_RESETTING_PIN = "p2ReferencesResettingPin";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Secret resettingPin;
    private Secret newPin;
    private boolean p2ReferencesResettingPin = false;

    protected void basicResetCredentialGui() throws CardApplicationException {
        IMessage title = this.getMsgTitleReset(false);
        IMessage prompt = this.getMsgPromptReset(false);
        Secret tmpResettingPin = this.queryPin(title, prompt);
        IPinInfo resettingPinInfo = this.getPinInfo().getResettingPinInfo();
        Secret tmpNewPin = null;
        Secret repeatPin = null;
        if (!resettingPinInfo.isResetRetryCounterOnly()) {
            title = this.getMsgTitleNew(false);
            prompt = this.getMsgPromptNew(false);
            tmpNewPin = this.queryPin(title, prompt);
            if (!LangTools.equals((Object)tmpNewPin, (Object)(repeatPin = this.queryPin(title = this.getMsgTitleRepeat(false), prompt = this.getMsgPromptRepeat(false))))) {
                throw new CardAuthenticationFailedException(this.getMessage("AbstractResetCredentialApp.error.PinMismatch", new Object[0]).getString());
            }
        }
        this.basicResetCredentialLiteral(tmpResettingPin, tmpNewPin);
    }

    protected void basicResetCredentialLiteral(Secret pResettingPin, Secret pNewPin) throws CardApplicationException {
        IPinInfo resettingPinInfo = this.getPinInfo().getResettingPinInfo();
        IPinInfo targetPinInfo = this.getPinInfo();
        if (this.isP2ReferencesResettingPin()) {
            targetPinInfo = resettingPinInfo;
        }
        this.getFileSystem().selectDf(targetPinInfo.getDirectory(), false);
        try {
            if (resettingPinInfo.isResetRetryCounterOnly()) {
                byte[] resettingCodeEncoded = resettingPinInfo.getPinCodec().encode(pResettingPin.getChars());
                this.cmdResetRetryCounter(targetPinInfo, resettingCodeEncoded);
            } else {
                byte[] resettingCodeEncoded = resettingPinInfo.getPinCodec().encode(pResettingPin.getChars());
                byte[] newSecretEncoded = this.getPinInfo().getPinCodec().encode(pNewPin.getChars());
                this.cmdResetRetryCounter(targetPinInfo, resettingCodeEncoded, newSecretEncoded);
            }
        }
        catch (GeneralSecurityException e) {
            throw CardApplicationException.create(e);
        }
    }

    protected void basicResetCredentialSpe() throws CardApplicationException {
        IPinInfo resettingPinInfo = this.getPinInfo().getResettingPinInfo();
        IPinInfo targetPinInfo = this.getPinInfo();
        if (this.isP2ReferencesResettingPin()) {
            targetPinInfo = resettingPinInfo;
        }
        this.getFileSystem().selectDf(targetPinInfo.getDirectory(), false);
        ICmdResetRetryCounter cmdReset = this.getCommand(ICmdResetRetryCounter.class);
        if (resettingPinInfo.isResetRetryCounterOnly()) {
            RequestAPDU template = cmdReset.createWithResettingCode(targetPinInfo.getReference(), resettingPinInfo.getPinCodec().getTemplate());
            IMessage[] messages = this.getMsgPrompts();
            ResponseAPDU response = this.getPinEntryApplication().sendVerifyRequest(template, resettingPinInfo.getPinCodec(), messages[0]);
            this.getCardProduct().checkResponse(template, response);
        } else {
            RequestAPDU template = cmdReset.create(targetPinInfo.getReference(), resettingPinInfo.getPinCodec().getTemplate(), resettingPinInfo.getPinCodec().getTemplate());
            IMessage[] messages = this.getMsgPrompts();
            CommonPinCodec tempCodec = (CommonPinCodec)targetPinInfo.getPinCodec().clone();
            if (resettingPinInfo.getPinCodec().getMinCharacters() < tempCodec.getMinCharacters()) {
                tempCodec.setMinCharacters(resettingPinInfo.getPinCodec().getMinCharacters());
            }
            if (resettingPinInfo.getPinCodec().getMaxCharacters() > tempCodec.getMaxCharacters()) {
                tempCodec.setMaxCharacters(resettingPinInfo.getPinCodec().getMaxCharacters());
            }
            ResponseAPDU response = this.getPinEntryApplication().sendModifyRequest(template, tempCodec, true, messages);
            this.getCardProduct().checkResponse(template, response);
        }
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setP2ReferencesResettingPin(ElementTools.getBoolean((IElement)element, (String)EA_P2_REFERENCES_RESETTING_PIN, (boolean)this.isP2ReferencesResettingPin()));
    }

    @Override
    protected IPinInfo[] filterPinInfos(IPinInfo[] pinInfos) throws CardApplicationException {
        ArrayList<IPinInfo> result = new ArrayList<IPinInfo>();
        IPinStateApplication pinStateApp = this.getCardProduct().createCardApplication(this.getCardConnection(), IPinStateApplication.class);
        for (IPinInfo pinInfo : pinInfos) {
            PinState resetPinState;
            IPinInfo resetPinInfo;
            PinState pinState = pinStateApp.getPinState(pinInfo);
            if (!pinState.isResettable() || (resetPinInfo = pinInfo.getResettingPinInfo()) == null || !(resetPinState = pinStateApp.getPinState(resetPinInfo)).isVerifiable()) continue;
            result.add(pinInfo);
        }
        return result.toArray(new IPinInfo[result.size()]);
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IResetCredentialApplication.class;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "ResetCredentialApp";
    }

    protected IMessage getMsgPromptDirect() {
        IMessage plainMsg;
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        String resettingPinLabel = this.getPinInfo().getResettingPinInfo().getLabel();
        if (this.getPinInfo().getResettingPinInfo().isResetRetryCounterOnly()) {
            plainMsg = this.getMessage("AbstractResetCredentialApp.pinDirectResetRetryCounter.promptSPE", terminalLabel, pinLabel, resettingPinLabel);
        } else {
            IPinCodec codec = this.getPinInfo().getPinCodec();
            String minLength = String.valueOf(codec.getMinCharacters());
            String maxLength = String.valueOf(codec.getMaxCharacters());
            plainMsg = this.getMessage("AbstractResetCredentialApp.pinDirectResetPinValue.promptSPE", terminalLabel, pinLabel, resettingPinLabel, minLength, maxLength);
        }
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptNew(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IPinCodec codec = this.getPinInfo().getPinCodec();
        String minLength = String.valueOf(codec.getMinCharacters());
        String maxLength = String.valueOf(codec.getMaxCharacters());
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractResetCredentialApp.pinNew.promptSPE", terminalLabel, pinLabel, minLength, maxLength) : this.getMessage("AbstractResetCredentialApp.pinNew.promptGUI", terminalLabel, pinLabel, minLength, maxLength);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptRepeat(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractResetCredentialApp.pinRepeat.promptSPE", terminalLabel, pinLabel) : this.getMessage("AbstractResetCredentialApp.pinRepeat.promptGUI", terminalLabel, pinLabel);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage getMsgPromptReset(boolean securePinEntry) {
        String terminalLabel = this.getCard().getCardTerminal().getName();
        String pinLabel = this.getPinInfo().getLabel();
        String resettingPinLabel = this.getPinInfo().getResettingPinInfo().getLabel();
        IMessage plainMsg = securePinEntry ? this.getMessage("AbstractResetCredentialApp.pinReset.promptSPE", terminalLabel, pinLabel, resettingPinLabel) : this.getMessage("AbstractResetCredentialApp.pinReset.promptGUI", terminalLabel, pinLabel, resettingPinLabel);
        String code = this.getMsgPromptCodeAuthentication();
        return MessageTools.createMessage((String)code, (IMessage)plainMsg, (Object[])new Object[]{this, this.getPinInfo()});
    }

    protected IMessage[] getMsgPrompts() throws CardApplicationException {
        ArrayList<IMessage> messages = new ArrayList<IMessage>(3);
        if (this.getPinInfo().getResettingPinInfo().isResetRetryCounterOnly()) {
            if (this.getPinEntryApplication().supportsPinVerifyIndirect(this.getPinInfo().getResettingPinInfo().getPinCodec())) {
                messages.add(this.getMsgPromptReset(true));
            } else {
                messages.add(this.getMsgPromptDirect());
            }
        } else if (this.getPinEntryApplication().supportsPinModifyIndirect(this.getPinInfo().getResettingPinInfo().getPinCodec())) {
            messages.add(this.getMsgPromptReset(true));
            messages.add(this.getMsgPromptNew(true));
            messages.add(this.getMsgPromptRepeat(true));
        } else {
            messages.add(this.getMsgPromptDirect());
        }
        return messages.toArray(new IMessage[messages.size()]);
    }

    protected IMessage getMsgTitleNew(boolean securePinEntry) {
        return this.getMessage("AbstractResetCredentialApp.pinNew.title", new Object[0]);
    }

    protected IMessage getMsgTitleRepeat(boolean securePinEntry) {
        return this.getMessage("AbstractResetCredentialApp.pinRepeat.title", new Object[0]);
    }

    protected IMessage getMsgTitleReset(boolean securePinEntry) {
        return this.getMessage("AbstractResetCredentialApp.pinReset.title", new Object[0]);
    }

    public Secret getNewPin() {
        return this.newPin;
    }

    public Secret getResettingPin() {
        return this.resettingPin;
    }

    protected boolean isP2ReferencesResettingPin() {
        return this.p2ReferencesResettingPin;
    }

    @Override
    public boolean isSupportedSPE() {
        try {
            return this.getPinEntryApplication().supportsPinModify(this.getPinInfo().getResettingPinInfo().getPinCodec()) && !this.isDisableSPE();
        }
        catch (CardApplicationException e) {
            return false;
        }
    }

    @Override
    public void resetCredential() throws CardApplicationException {
        this.basicBeginTransaction();
        if (!CryptoTools.isEmpty((Secret)this.getResettingPin()) && !CryptoTools.isEmpty((Secret)this.getNewPin())) {
            this.basicResetCredentialLiteral(this.getResettingPin(), this.getNewPin());
        } else if (this.isSupportedSPE()) {
            this.basicResetCredentialSpe();
        } else {
            if (this.isEnforceSPE()) {
                throw new SpeRequiredException();
            }
            this.basicResetCredentialGui();
        }
    }

    @Override
    public void setNewPin(Secret newPin) {
        this.newPin = newPin;
    }

    protected void setP2ReferencesResettingPin(boolean p1HoldsResettingPin) {
        this.p2ReferencesResettingPin = p1HoldsResettingPin;
    }

    @Override
    public void setResettingPin(Secret resettingPin) {
        this.resettingPin = resettingPin;
    }
}

