/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.smartcard.app.common.AbstractCardHolderApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.app.common.PACKAGE;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.annotation.PostConstruct;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSignApp
extends AbstractCardHolderApplication
implements ISignApplication {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Collection<String> supportedHashAlgorithmNames = null;
    private String hashAlgorithmName;
    private AlgorithmParameterSpec algorithmParameterSpec;

    protected abstract byte[] basicSign(byte[] var1) throws CardApplicationException;

    protected AlgorithmParameterSpec createAlgorithmParameterSpec() throws CardApplicationException {
        if (this.getHashAlgorithmName() == null) {
            return null;
        }
        IMechanism mechanism = this.detectMechanism();
        return this.createAlgorithmParameterSpec(mechanism);
    }

    protected AlgorithmParameterSpec createAlgorithmParameterSpec(IMechanism mechanism) throws CardApplicationException {
        if (mechanism == null) {
            return null;
        }
        String name = mechanism.getOutputEncodingAlgorithmName();
        if (name == null) {
            return null;
        }
        if ("PSS".equals(name)) {
            return PSSEncoding.createPSSParameterSpec((String)this.getHashAlgorithmName());
        }
        throw new CardApplicationException("encoding " + name + " not supported");
    }

    protected byte[] createPSOInput(byte[] data, IMechanism mechanism) throws CardApplicationException {
        String name = mechanism.getInputEncodingAlgorithmName();
        if (name == null) {
            return data;
        }
        if ("DigestInfo".equals(name)) {
            return data;
        }
        if ("Raw".equals(name)) {
            IDigest digest = this.parseDigest(data);
            return digest.getBytes();
        }
        if ("PSS".equals(name)) {
            try {
                IDigest digest = this.parseDigest(data);
                PSSEncoding encoding = new PSSEncoding();
                encoding.setDerEncoded(false);
                encoding.setIntendedLengthBits(this.getCardHolderCertificate().getKeyBitSize());
                encoding.setDigester(DigestTools.createDigester((String)digest.getAlgorithmName()));
                encoding.setSaltLength(data.length);
                return encoding.encode(digest.getBytes());
            }
            catch (Exception e) {
                throw CardApplicationException.create("encoding failed", e);
            }
        }
        throw new CardApplicationException("encoding " + name + " not supported");
    }

    @Override
    protected boolean detectMechanismSupports(IMechanism aMechanism) throws CardApplicationException {
        List<String> names = aMechanism.getHashAlgorithmNames();
        if (names != null && !names.isEmpty()) {
            String current = this.getHashAlgorithmName();
            if (current == null) {
                return true;
            }
            return DigestAlgorithm.contains(names, (String)current);
        }
        return super.detectMechanismSupports(aMechanism);
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    protected String getDefaultEncodingSchemeName() {
        return "PKCS1Type1";
    }

    @Override
    public String getEncryptionAlgorithmName() {
        if (this.getCardHolderCertificate() != null) {
            return this.getCardHolderCertificate().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        Iterator<CardApplicationBinding> iterator = this.getBindings().iterator();
        if (iterator.hasNext()) {
            CardApplicationBinding binding = iterator.next();
            return binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName();
        }
        return null;
    }

    @Override
    public String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "SignApp";
    }

    @Override
    public Collection<String> getSupportedEncryptionAlgorithmNames() {
        HashSet<String> names = new HashSet<String>();
        for (CardApplicationBinding binding : this.getBindings()) {
            names.add(binding.getCardHolderCertificateInfo().getPrivateKeyInfo().getEncryptionAlgorithmName());
        }
        return names;
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.supportedHashAlgorithmNames;
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        HashSet<String> tempSupported = new HashSet<String>();
        for (CardApplicationBinding binding : this.getBindings()) {
            for (IMechanism mechanism : binding.getMechanisms()) {
                List<String> tempNames = mechanism.getHashAlgorithmNames();
                List tempAlgorithms = DigestAlgorithm.lookupAlgorithms(tempNames);
                for (DigestAlgorithm tempAlgorithm : tempAlgorithms) {
                    tempSupported.add(tempAlgorithm.getCanonicalName());
                }
            }
        }
        if (tempSupported.isEmpty()) {
            tempSupported.addAll(DIGEST_ALGORITHMS_ALL);
        }
        this.setSupportedHashAlgorithmNames(tempSupported);
    }

    protected IDigest parseDigest(byte[] data) throws CardApplicationException {
        try {
            return DigestTools.decode((byte[])data);
        }
        catch (Exception e) {
            throw new CardApplicationException("message must be a ASN.1 DigestInfo");
        }
    }

    protected void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public void setHashAlgorithmName(String hashAlgorithmName) throws CardApplicationException {
        this.hashAlgorithmName = hashAlgorithmName;
        this.setAlgorithmParameterSpec(this.createAlgorithmParameterSpec());
    }

    protected void setSupportedHashAlgorithmNames(Collection<String> supportedHashAlgorithmNames) {
        this.supportedHashAlgorithmNames = supportedHashAlgorithmNames;
    }

    @Override
    public final byte[] sign(byte[] data) throws CardApplicationException {
        if (this.getCardHolderCertificate() == null) {
            throw new CardApplicationException("key not specified");
        }
        IDigest digest = this.parseDigest(data);
        this.setHashAlgorithmName(digest.getAlgorithmName());
        this.authenticate();
        try {
            this.incUseCount();
            byte[] byArray = this.basicSign(data);
            return byArray;
        }
        catch (CardApplicationException e) {
            this.basicResetSecurityState();
            throw e;
        }
        finally {
            this.basicOperationCleanup();
        }
    }
}

