/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCompositeCardHolderApplication;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.exception.InvalidRequestException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class CompositeAuthenticateApp
extends AbstractCompositeCardHolderApplication
implements IAuthenticateApplication {
    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IAuthenticateApplication.class;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        if (this.getSelectedApplication() != null) {
            return ((IAuthenticateApplication)this.getSelectedApplication()).getEncryptionAlgorithmName();
        }
        Iterator<ICardHolderApplication> iterator = this.getCardHolderApplications().iterator();
        if (iterator.hasNext()) {
            ICardHolderApplication app = iterator.next();
            return ((IAuthenticateApplication)app).getEncryptionAlgorithmName();
        }
        return null;
    }

    @Override
    public int getMaximumChallengeLength() {
        if (this.getSelectedApplication() != null) {
            return ((IAuthenticateApplication)this.getSelectedApplication()).getMaximumChallengeLength();
        }
        Iterator<ICardHolderApplication> iterator = this.getCardHolderApplications().iterator();
        if (iterator.hasNext()) {
            ICardHolderApplication app = iterator.next();
            return ((IAuthenticateApplication)app).getMaximumChallengeLength();
        }
        return 0;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "AuthenticateApp";
    }

    @Override
    public int getRestrictionCount() {
        if (this.getSelectedApplication() != null) {
            return ((IAuthenticateApplication)this.getSelectedApplication()).getRestrictionCount();
        }
        int count = -1;
        for (ICardHolderApplication app : this.getCardHolderApplications()) {
            if (((IAuthenticateApplication)app).getRestrictionCount() <= 0 || count != -1 && count <= ((IAuthenticateApplication)app).getRestrictionCount()) continue;
            count = ((IAuthenticateApplication)app).getRestrictionCount();
        }
        return count;
    }

    @Override
    public Collection<String> getSupportedEncryptionAlgorithmNames() {
        if (this.getSelectedApplication() != null) {
            return ((IAuthenticateApplication)this.getSelectedApplication()).getSupportedEncryptionAlgorithmNames();
        }
        Iterator<ICardHolderApplication> iterator = this.getCardHolderApplications().iterator();
        if (iterator.hasNext()) {
            ICardHolderApplication app = iterator.next();
            return ((IAuthenticateApplication)app).getSupportedEncryptionAlgorithmNames();
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] sign(byte[] data) throws CardApplicationException {
        if (this.getSelectedApplication() != null) {
            return ((IAuthenticateApplication)this.getSelectedApplication()).sign(data);
        }
        throw new InvalidRequestException("no application selected");
    }
}

